/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ScheduledFutureDecorator<V>
implements ScheduledFuture<V> {
    private ScheduledFuture<V> scheduled;
    private RunnableFuture<?> task;
    private boolean periodic;

    ScheduledFutureDecorator(ScheduledFuture<V> scheduled, RunnableFuture<?> task, boolean periodic) {
        this.scheduled = scheduled;
        this.task = task;
        this.periodic = periodic;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.scheduled.getDelay(unit);
    }

    @Override
    public int compareTo(Delayed o) {
        return this.scheduled.compareTo(o);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean scheduledCancelled = this.scheduled.cancel(mayInterruptIfRunning);
        boolean taskCancelled = this.task.cancel(mayInterruptIfRunning);
        return scheduledCancelled || taskCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.scheduled.isCancelled() || this.task.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.scheduled.isDone() || this.task.isDone();
    }

    public boolean isPeriodic() {
        return this.periodic;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.task.get();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.task.get(timeout, unit);
    }
}

