/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.csv.reader.parser;

import org.mule.weave.v2.model.service.SettingsService;
import org.mule.weave.v2.module.core.csv.reader.parser.CSVSettings;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4A\u0001E\t\u0001I!A1\u0006\u0001BC\u0002\u0013\u0005A\u0006\u0003\u00052\u0001\t\u0005\t\u0015!\u0003.\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0004\"B\u001e\u0001\t\u0003a\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002+\u0001\t\u0003)\u0006\"B.\u0001\t\u0003a\u0006\"\u00020\u0001\t\u0003y\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B3\u0001\t\u00031\u0007\"\u00025\u0001\t\u0003I\u0007\"B6\u0001\t\u0003a\u0007\"\u00028\u0001\t\u0013y\u0007\"\u00029\u0001\t\u0003\t\b\"B:\u0001\t\u0003y'!E\"T-N+G\u000f^5oONDU\r\u001c9fe*\u0011!cE\u0001\u0007a\u0006\u00148/\u001a:\u000b\u0005Q)\u0012A\u0002:fC\u0012,'O\u0003\u0002\u0017/\u0005\u00191m\u001d<\u000b\u0005aI\u0012\u0001B2pe\u0016T!AG\u000e\u0002\r5|G-\u001e7f\u0015\taR$\u0001\u0002we)\u0011adH\u0001\u0006o\u0016\fg/\u001a\u0006\u0003A\u0005\nA!\\;mK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\f1bY:w'\u0016$H/\u001b8hgV\tQ\u0006\u0005\u0002/_5\t\u0011#\u0003\u00021#\tY1i\u0015,TKR$\u0018N\\4t\u00031\u00197O^*fiRLgnZ:!\u0003=\u0019X\r\u001e;j]\u001e\u001c8+\u001a:wS\u000e,\u0007C\u0001\u001b:\u001b\u0005)$B\u0001\u001c8\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001O\u000e\u0002\u000b5|G-\u001a7\n\u0005i*$aD*fiRLgnZ:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\ridh\u0010\t\u0003]\u0001AQa\u000b\u0003A\u00025BQA\r\u0003A\u0002M\n\u0001\"\u001e8fg\u000e\f\u0007/\u001a\u000b\u0004\u00056{\u0005CA\"K\u001d\t!\u0005\n\u0005\u0002FO5\taI\u0003\u0002HG\u00051AH]8pizJ!!S\u0014\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013\u001eBQAT\u0003A\u0002\t\u000bQA^1mk\u0016DQ\u0001U\u0003A\u0002E\u000b\u0001\"[:Rk>$X\r\u001a\t\u0003MIK!aU\u0014\u0003\u000f\t{w\u000e\\3b]\u00061\"/Z9vSJ,7/R:dCB,\u0017J\\)v_R,G\r\u0006\u0002R-\")qK\u0002a\u00011\u0006!1\r[1s!\t1\u0013,\u0003\u0002[O\t!1\t[1s\u00039\u0011X-];je\u0016\u001cXi]2ba\u0016$\"!U/\t\u000b];\u0001\u0019\u0001-\u0002\u0019%\u001cH*\u001b8f\u000b:$\u0017N\\4\u0015\u0005E\u0003\u0007\"B1\t\u0001\u0004A\u0016!A2\u0002\u0017%\u001c\u0018+^8uK\u000eC\u0017M\u001d\u000b\u0003#\u0012DQ!Y\u0005A\u0002a\u000b\u0011#[:D_2,XN\\*fa\u0006\u0014\u0018\r^8s)\t\tv\rC\u0003b\u0015\u0001\u0007\u0001,\u0001\u0007jg\u0016\u001b8-\u00199f\u0007\"\f'\u000f\u0006\u0002RU\")\u0011m\u0003a\u00011\u0006!Rm]2ba\u0016,f.];pi\u0016$7\u000b\u001e:j]\u001e$\"AQ7\t\u000b9c\u0001\u0019\u0001\"\u0002%\u0005dw/Y=t\u000bN\u001c\u0017\r]3Rk>$Xm\u001d\u000b\u0002#\u0006\u0011Rm]2ba\u0016\fVo\u001c;fIN#(/\u001b8h)\t\u0011%\u000fC\u0003O\u001d\u0001\u0007!)\u0001\u0015sKR\f\u0017N\\*ue&twMV1mk\u0016Le.T3n_JLxJ\\%oI\u0016DX\r\u001a*fC\u0012,'\u000f")
public class CSVSettingsHelper {
    private final CSVSettings csvSettings;
    private final SettingsService settingsService;

    public CSVSettings csvSettings() {
        return this.csvSettings;
    }

    public String unescape(String value, boolean isQuoted) {
        StringBuilder result = new StringBuilder();
        char[] array = value.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            StringBuilder stringBuilder;
            boolean isEscapeAndNextIsQuote;
            char c = array[i];
            boolean bl = isEscapeAndNextIsQuote = this.isEscapeChar(c) && i + 1 < array.length && this.needsEscape$1(array[i + 1], isQuoted);
            if (!isEscapeAndNextIsQuote) {
                stringBuilder = result.append(c);
                continue;
            }
            result.append(array[i + 1]);
            ++i;
            stringBuilder = BoxedUnit.UNIT;
        }
        return result.toString();
    }

    public boolean requiresEscapeInQuoted(char c) {
        return this.csvSettings().requiresEscapeInQuoted(c);
    }

    public boolean requiresEscape(char c) {
        return this.csvSettings().requiresEscape(c);
    }

    public boolean isLineEnding(char c) {
        return this.csvSettings().isLineEnding(c);
    }

    public boolean isQuoteChar(char c) {
        return this.csvSettings().isQuoteChar(c);
    }

    public boolean isColumnSeparator(char c) {
        return this.csvSettings().isColumnSeparator(c);
    }

    public boolean isEscapeChar(char c) {
        return this.csvSettings().isEscapeChar(c);
    }

    public String escapeUnquotedString(String value) {
        StringBuilder result = new StringBuilder();
        char maybeEscape = this.csvSettings().escape();
        for (int i = 0; i < value.length(); ++i) {
            Object object;
            char c = value.charAt(i);
            if (maybeEscape != '\u0000') {
                boolean needsEscaping;
                boolean bl = needsEscaping = this.isEscapeChar(c) || this.isColumnSeparator(c) || this.isLineEnding(c) || this.isQuoteChar(c) && this.alwaysEscapeQuotes();
                object = needsEscaping ? result.append(maybeEscape) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean alwaysEscapeQuotes() {
        return this.settingsService.csvWriter().alwaysEscapeQuotesInCSV();
    }

    public String escapeQuotedString(String value) {
        StringBuilder result = new StringBuilder();
        char maybeEscape = this.csvSettings().escape();
        for (int i = 0; i < value.length(); ++i) {
            Object object;
            char c = value.charAt(i);
            if (maybeEscape != '\u0000') {
                boolean needsEscaping;
                boolean bl = needsEscaping = this.isEscapeChar(c) || this.isQuoteChar(c);
                object = needsEscaping ? result.append(maybeEscape) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            result.append(c);
        }
        return result.toString();
    }

    public boolean retainStringValueInMemoryOnIndexedReader() {
        return this.settingsService.csvReader().retainStringValueInMemoryOnIndexedReader();
    }

    private final boolean needsEscape$1(char c, boolean isQuoted$1) {
        return isQuoted$1 ? this.requiresEscapeInQuoted(c) : this.requiresEscape(c);
    }

    public CSVSettingsHelper(CSVSettings csvSettings, SettingsService settingsService) {
        this.csvSettings = csvSettings;
        this.settingsService = settingsService;
    }
}

