/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.util.Locale;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.values.LocalDateValue;
import org.mule.weave.v2.model.values.LocalDateValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.TemporalCoercer;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Option;
import scala.util.Failure;
import scala.util.Try$;

public final class LocalDateCoercer$
implements ValueCoercer<LocalDateValue>,
TemporalCoercer<LocalDate> {
    public static LocalDateCoercer$ MODULE$;

    static {
        new LocalDateCoercer$();
    }

    @Override
    public Object stringCoercion(CharSequence str, TemporalQuery from, LocationCapable locationCapable, Option schema, EvaluationContext ctx) {
        return TemporalCoercer.stringCoercion$(this, str, from, locationCapable, schema, ctx);
    }

    @Override
    public Object parseTemporal(CharSequence str, String format, Locale locale, Option mode, TemporalQuery from, LocationCapable locationCapable, EvaluationContext ctx) {
        return TemporalCoercer.parseTemporal$(this, str, format, locale, mode, from, locationCapable, ctx);
    }

    @Override
    public Option<LocalDateValue> coerceMaybe(Value<?> value, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetSchema, locationCapable, evaluationContext);
    }

    public TemporalQuery<LocalDate> FROM(String literal) {
        return temporal -> {
            void var2_2;
            LocalDate date = temporal.query(TemporalQueries.localDate());
            if (date == null) {
                throw new DateTimeException(new StringBuilder(29).append("Unable to convert `").append(literal).append("` to Date.").toString());
            }
            return var2_2;
        };
    }

    @Override
    public LocalDateValue coerce(Value<?> c, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        LocalDate localDate;
        Value<?> value = c;
        if (LocalDateType$.MODULE$.accepts(value, ctx)) {
            localDate = (LocalDate)c.evaluate(ctx);
        } else if (DateTimeType$.MODULE$.accepts(value, ctx)) {
            localDate = ((ZonedDateTime)c.evaluate(ctx)).toLocalDate();
        } else if (LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
            localDate = ((LocalDateTime)c.evaluate(ctx)).toLocalDate();
        } else if (StringType$.MODULE$.accepts(value, ctx)) {
            CharSequence literal = (CharSequence)c.evaluate(ctx);
            localDate = (LocalDate)this.stringCoercion(literal, this.FROM(((Object)literal).toString()), locationCapable, (Option)targetSchema, ctx);
        } else {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), c.valueType(ctx), LocalDateType$.MODULE$.withSchema(targetSchema), c, ctx);
        }
        LocalDate coercedValue = localDate;
        return LocalDateValue$.MODULE$.apply(coercedValue, locationCapable, targetSchema);
    }

    @Override
    public LocalDate fallbackStringCoercion(CharSequence str, LocationCapable locationCapable, EvaluationContext ctx) {
        return (LocalDate)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> LocalDate.parse(str)).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> LocalDate.parse(str, DateTimeFormatter.ISO_WEEK_DATE))).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> LocalDate.parse(str, DateTimeFormatter.ISO_ORDINAL_DATE))).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ZonedDateTime.parse(str).toLocalDate())).orElse((Function0 & Serializable & scala.Serializable)() -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> LocalDateTime.parse(str).toLocalDate())).orElse((Function0 & Serializable & scala.Serializable)() -> new Failure((Throwable)new UnsupportedTypeCoercionException(locationCapable.location(), StringType$.MODULE$, LocalDateType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ((Object)str).toString(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$5(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx))).get();
    }

    @Override
    public Type targetType() {
        return LocalDateType$.MODULE$;
    }

    private LocalDateCoercer$() {
        MODULE$ = this;
        ValueCoercer.$init$(this);
        TemporalCoercer.$init$(this);
    }
}

