/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import java.util.function.Function;
import org.slf4j.Logger;

public class FailsafeUnaryCommandExecutor<A, R> {
    private final Logger customLogger;
    private final String errorMessage;
    private final boolean propagateExceptions;
    private final R onFailureReturn;

    public FailsafeUnaryCommandExecutor(Logger customLogger, String errorMessage, boolean propagateExceptions, R onFailureReturn) {
        this.customLogger = customLogger;
        this.errorMessage = errorMessage;
        this.propagateExceptions = propagateExceptions;
        this.onFailureReturn = onFailureReturn;
    }

    public R execute(Function<A, R> function, A param) {
        try {
            return function.apply(param);
        }
        catch (Throwable e) {
            if (this.propagateExceptions) {
                throw e;
            }
            if (this.customLogger.isWarnEnabled()) {
                this.customLogger.warn(this.errorMessage, e);
            }
            return this.onFailureReturn;
        }
    }
}

