/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.SimpleConfigurationBuilder;
import org.mule.runtime.core.api.context.MuleContextBuilder;
import org.mule.runtime.core.api.context.MuleContextFactory;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.internal.config.builders.AutoConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMuleContextFactory
implements MuleContextFactory {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultMuleContextFactory.class);
    private final List<MuleContextListener> listeners = new LinkedList<MuleContextListener>();

    @Override
    public MuleContext createMuleContext(ConfigurationBuilder ... configurationBuilders) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(Arrays.asList(configurationBuilders), MuleContextBuilder.builder(ArtifactType.APP));
    }

    @Override
    public MuleContext createMuleContext(List<ConfigurationBuilder> configurationBuilders, MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(muleContextBuilder, muleContext -> {
            for (ConfigurationBuilder configBuilder : configurationBuilders) {
                configBuilder.configure(muleContext);
            }
        });
    }

    @Override
    public MuleContext createMuleContext(ConfigurationBuilder configurationBuilder, MuleContextBuilder muleContextBuilder) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(muleContextBuilder, muleContext -> configurationBuilder.configure(muleContext));
    }

    @Deprecated
    public MuleContext createMuleContext(String resource) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(resource, Collections.emptyMap());
    }

    @Deprecated
    public MuleContext createMuleContext(String configResources, Map<String, Object> properties) throws InitialisationException, ConfigurationException {
        return this.doCreateMuleContext(MuleContextBuilder.builder(ArtifactType.APP), muleContext -> {
            if (!properties.isEmpty()) {
                new SimpleConfigurationBuilder(properties).configure(muleContext);
            }
            new AutoConfigurationBuilder(configResources, Collections.emptyMap(), ArtifactType.APP).configure(muleContext);
        });
    }

    public MuleContext createMuleContext(ConfigurationBuilder configurationBuilder, Map<String, Object> properties) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(configurationBuilder, properties, (MuleConfiguration)new DefaultMuleConfiguration());
    }

    public MuleContext createMuleContext(List<ConfigurationBuilder> configurationBuilders, Map<String, Object> properties) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(configurationBuilders, properties, (MuleConfiguration)new DefaultMuleConfiguration());
    }

    public MuleContext createMuleContext(ConfigurationBuilder configurationBuilder, Map<String, Object> properties, MuleConfiguration configuration) throws InitialisationException, ConfigurationException {
        return this.createMuleContext(Collections.singletonList(configurationBuilder), properties, configuration);
    }

    public MuleContext createMuleContext(List<ConfigurationBuilder> configurationBuilders, Map<String, Object> properties, MuleConfiguration configuration) throws InitialisationException, ConfigurationException {
        MuleContextBuilder contextBuilder = MuleContextBuilder.builder(ArtifactType.APP);
        contextBuilder.setMuleConfiguration(configuration);
        return this.doCreateMuleContext(contextBuilder, muleContext -> {
            if (!properties.isEmpty()) {
                new SimpleConfigurationBuilder(properties).configure(muleContext);
            }
            for (ConfigurationBuilder configurationBuilder : configurationBuilders) {
                configurationBuilder.configure(muleContext);
            }
        });
    }

    private MuleContext doCreateMuleContext(MuleContextBuilder muleContextBuilder, ContextConfigurator configurator) throws InitialisationException, ConfigurationException {
        MuleContext muleContext = this.buildMuleContext(muleContextBuilder);
        this.listeners.forEach(l -> l.onCreation(muleContext));
        try {
            configurator.configure(muleContext);
            muleContext.initialise();
        }
        catch (ConfigurationException e) {
            block5: {
                if (muleContext != null && !muleContext.isDisposed()) {
                    try {
                        muleContext.dispose();
                    }
                    catch (Exception e1) {
                        e.addSuppressed(e1);
                        logger.warn("Can not dispose context. {}", (Object)ExceptionUtils.getMessage((Throwable)e1));
                        if (!logger.isDebugEnabled()) break block5;
                        logger.debug("Can not dispose context. {}", (Object)ExceptionUtils.getStackTrace((Throwable)e1));
                    }
                }
            }
            throw e;
        }
        return muleContext;
    }

    protected MuleContext buildMuleContext(MuleContextBuilder muleContextBuilder) {
        muleContextBuilder.setListeners(this.listeners);
        return muleContextBuilder.buildMuleContext();
    }

    @Override
    public void addListener(MuleContextListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(MuleContextListener listener) {
        return this.listeners.remove(listener);
    }

    private static interface ContextConfigurator {
        public void configure(MuleContext var1) throws ConfigurationException;
    }
}

