/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class StaticParameterValueResolver
implements ParameterValueResolver {
    private final Map<String, ValueResolver<?>> resolvedParameters;

    public static ParameterValueResolver from(Map<String, ?> parameters) {
        return new StaticParameterValueResolver(parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new StaticValueResolver(e.getValue()))));
    }

    private StaticParameterValueResolver(Map<String, ValueResolver<?>> resolvedParameters) {
        this.resolvedParameters = new HashMap(resolvedParameters);
    }

    @Override
    public Object getParameterValue(String parameterName) throws ValueResolvingException {
        if (this.resolvedParameters.containsKey(parameterName)) {
            try {
                return this.resolvedParameters.get(parameterName).resolve(null);
            }
            catch (MuleException e) {
                throw new ValueResolvingException("Could not resolve value for " + parameterName, e);
            }
        }
        return null;
    }

    @Override
    public Map<String, ValueResolver<? extends Object>> getParameters() throws ValueResolvingException {
        return Collections.unmodifiableMap(this.resolvedParameters);
    }
}

