/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.util;

import java.net.URL;
import java.security.AccessController;

public class ClassUtils {
    public static URL getResource(String resourceName, Class<?> callingClass) {
        URL url = AccessController.doPrivileged(() -> {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl != null ? cl.getResource(resourceName) : null;
        });
        if (url == null) {
            url = AccessController.doPrivileged(() -> ClassUtils.class.getClassLoader().getResource(resourceName));
        }
        if (url == null) {
            url = AccessController.doPrivileged(() -> callingClass.getClassLoader().getResource(resourceName));
        }
        return url;
    }
}

