/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.interception;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.message.InternalEvent;
import org.mule.runtime.core.privileged.event.MuleSession;
import org.mule.runtime.core.privileged.interception.InternalInterceptionEvent;

public class DefaultInterceptionEvent
implements InternalInterceptionEvent {
    public static final String INTERCEPTION_RESOLVED_PARAMS = "core:interceptionResolvedParams";
    public static final String INTERCEPTION_RESOLVED_CONTEXT = "core:interceptionResolvedContext";
    public static final String INTERCEPTION_COMPONENT = "core:interceptionComponent";
    private InternalEvent interceptedInput;
    private InternalEvent.Builder interceptedOutput;

    public DefaultInterceptionEvent(InternalEvent interceptedInput) {
        this.reset(interceptedInput);
    }

    public Message getMessage() {
        return this.interceptedInput.getMessage();
    }

    public Map<String, TypedValue<?>> getVariables() {
        return this.interceptedInput.getVariables();
    }

    public Map<String, TypedValue<?>> getParameters() {
        return this.interceptedInput.getParameters();
    }

    public Optional<Error> getError() {
        return this.interceptedInput.getError();
    }

    public String getCorrelationId() {
        return this.interceptedInput.getCorrelationId();
    }

    public Optional<ItemSequenceInfo> getItemSequenceInfo() {
        return this.interceptedInput.getItemSequenceInfo();
    }

    public EventContext getContext() {
        return this.interceptedInput.getContext();
    }

    public Optional<Authentication> getAuthentication() {
        return this.interceptedInput.getAuthentication();
    }

    @Override
    public MuleSession getSession() {
        return this.interceptedInput.getSession();
    }

    public DefaultInterceptionEvent message(Message message) {
        this.interceptedOutput = this.interceptedOutput.message(message).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        return this;
    }

    public DefaultInterceptionEvent variables(Map<String, Object> variables) {
        this.interceptedOutput = this.interceptedOutput.variables((Map)variables).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        return this;
    }

    public DefaultInterceptionEvent addVariable(String key, Object value) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        return this;
    }

    public DefaultInterceptionEvent addVariable(String key, Object value, DataType mediaType) {
        this.interceptedOutput = this.interceptedOutput.addVariable(key, value, mediaType).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        return this;
    }

    public DefaultInterceptionEvent removeVariable(String key) {
        this.interceptedOutput = this.interceptedOutput.removeVariable(key).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        return this;
    }

    @Override
    public DefaultInterceptionEvent session(MuleSession session) {
        this.interceptedOutput = this.interceptedOutput.session(session).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        return this;
    }

    public DefaultInterceptionEvent setError(ErrorType errorType, Throwable cause) {
        ErrorBuilder errorBuilder = ErrorBuilder.builder(cause);
        errorBuilder.errorType(errorType);
        this.interceptedOutput = this.interceptedOutput.error(errorBuilder.build()).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        return this;
    }

    public BindingContext asBindingContext() {
        return BindingContextUtils.addEventBindings((Event)this.resolve(), (BindingContext)BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public InternalEvent resolve() {
        InternalEvent newEvent = this.interceptedOutput.build();
        if (this.interceptedInput != newEvent) {
            this.interceptedInput = newEvent;
            this.interceptedOutput = InternalEvent.builder(this.interceptedInput).removeInternalParameter(INTERCEPTION_RESOLVED_PARAMS);
        }
        return this.interceptedInput;
    }

    public InternalEvent getInterceptionResult() {
        return this.interceptedInput;
    }

    public DefaultInterceptionEvent reset(InternalEvent newEvent) {
        this.interceptedInput = newEvent;
        this.interceptedOutput = InternalEvent.builder(newEvent);
        return this;
    }
}

