/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.stream.JsonGenerator;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonGeneratorImpl;

public class JsonPrettyGeneratorImpl
extends JsonGeneratorImpl {
    private int indentLevel;
    private static final String INDENT = "    ";

    public JsonPrettyGeneratorImpl(Writer writer, JsonContext jsonContext) {
        super(writer, jsonContext);
    }

    public JsonPrettyGeneratorImpl(OutputStream out, JsonContext jsonContext) {
        super(out, jsonContext);
    }

    public JsonPrettyGeneratorImpl(OutputStream out, Charset encoding, JsonContext jsonContext) {
        super(out, encoding, jsonContext);
    }

    @Override
    public JsonGenerator writeStartObject() {
        super.writeStartObject();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        super.writeStartObject(name);
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        super.writeStartArray();
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        super.writeStartArray(name);
        ++this.indentLevel;
        return this;
    }

    @Override
    public JsonGenerator writeEnd() {
        this.writeNewLine();
        --this.indentLevel;
        this.writeIndent();
        super.writeEnd();
        return this;
    }

    private void writeIndent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.writeString(INDENT);
        }
    }

    @Override
    protected void writeComma() {
        super.writeComma();
        if (this.isCommaAllowed() && !this.inNone()) {
            this.writeChar('\n');
            this.writeIndent();
        }
    }

    @Override
    protected void writeColon() {
        super.writeColon();
        this.writeChar(' ');
    }

    private void writeNewLine() {
        this.writeChar('\n');
    }
}

