/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.tracing.ExecutionContext;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.service.scheduler.internal.profiling.DefaultTaskSchedulingProfilingEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class AbstractRunnableFutureDecorator<V>
implements RunnableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRunnableFutureDecorator.class);
    private ClassLoader classLoader;
    private Thread runningThread;
    private Object previousThreadLocals;
    private static final Field threadLocalsField;
    private final int id;
    private volatile boolean ranAtLeastOnce = false;
    private volatile boolean started = false;
    private ProfilingService profilingService = null;
    private ExecutionContext initialExecutionContext = null;

    private void rememberAndClearCurrentThreadLocals() {
        try {
            this.previousThreadLocals = threadLocalsField.get(Thread.currentThread());
            threadLocalsField.set(Thread.currentThread(), null);
        }
        catch (IllegalAccessException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void restorePreviousThreadLocals() {
        try {
            threadLocalsField.set(Thread.currentThread(), this.previousThreadLocals);
            this.previousThreadLocals = null;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    protected AbstractRunnableFutureDecorator(int id, ClassLoader classLoader, ProfilingService profilingService) {
        this.id = id;
        this.classLoader = classLoader;
        if (this.shouldProfile(profilingService)) {
            this.profilingService = profilingService;
            this.initialExecutionContext = profilingService.getTracingService().getCurrentExecutionContext();
            profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.SCHEDULING_TASK_EXECUTION).triggerProfilingEvent((ProfilingEventContext)new DefaultTaskSchedulingProfilingEventContext(System.currentTimeMillis(), String.valueOf(id), Thread.currentThread().getName(), this.initialExecutionContext));
        }
    }

    protected long beforeRun() {
        long startTime = 0L;
        if (logger.isTraceEnabled()) {
            startTime = System.nanoTime();
            logger.trace("Starting task " + this + "...");
        }
        this.ranAtLeastOnce = true;
        this.started = true;
        this.rememberAndClearCurrentThreadLocals();
        return startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun(RunnableFuture<V> task) {
        ClassLoader cl = this.classLoader;
        if (cl == null) {
            if (!logger.isDebugEnabled()) return;
            logger.debug("Task " + this + " has been cancelled. Returning immediately.");
            return;
        }
        long startTime = this.beforeRun();
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        String currentThreadName = currentThread.getName();
        currentThread.setContextClassLoader(cl);
        if (this.getThreadNameSuffix() != null) {
            currentThread.setName(currentThreadName.concat(": ").concat(this.getThreadNameSuffix()));
        }
        this.runningThread = currentThread;
        if (logger.isTraceEnabled()) {
            MDC.put((String)"task", (String)task.toString());
        }
        try {
            if (this.shouldProfile(this.profilingService)) {
                if (this.initialExecutionContext != null) {
                    this.profilingService.getTracingService().setCurrentExecutionContext(this.initialExecutionContext);
                }
                this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.STARTING_TASK_EXECUTION).triggerProfilingEvent((ProfilingEventContext)new DefaultTaskSchedulingProfilingEventContext(System.currentTimeMillis(), String.valueOf(this.id), Thread.currentThread().getName(), this.profilingService.getTracingService().getCurrentExecutionContext()));
            }
            task.run();
            if (task.isCancelled()) {
                if (!logger.isTraceEnabled()) return;
                logger.trace("Task " + this + " cancelled");
                return;
            }
            task.get();
            return;
        }
        catch (ExecutionException e) {
            logger.error("Uncaught throwable in task " + this, (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            currentThread.interrupt();
            return;
        }
        finally {
            try {
                this.wrapUp();
            }
            catch (Exception e) {
                logger.error("Exception wrapping up execution of " + this, (Throwable)e);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace("Task " + this + " finished after " + (System.nanoTime() - startTime) + " nanoseconds");
                }
                currentThread.setContextClassLoader(currentClassLoader);
                if (this.getThreadNameSuffix() != null) {
                    currentThread.setName(currentThreadName);
                }
            }
        }
    }

    protected void resetClassloader() {
        this.classLoader = null;
    }

    protected void wrapUp() throws Exception {
        if (this.shouldProfile(this.profilingService)) {
            this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TASK_EXECUTED).triggerProfilingEvent((ProfilingEventContext)new DefaultTaskSchedulingProfilingEventContext(System.currentTimeMillis(), String.valueOf(this.id), Thread.currentThread().getName(), this.profilingService.getTracingService().getCurrentExecutionContext()));
            this.profilingService.getTracingService().deleteCurrentExecutionContext();
        }
        this.started = false;
        this.runningThread = null;
        this.restorePreviousThreadLocals();
    }

    boolean isRanAtLeastOnce() {
        return this.ranAtLeastOnce;
    }

    boolean isStarted() {
        return this.started;
    }

    public Thread getRunningThread() {
        return this.runningThread;
    }

    public int hashCode() {
        return Integer.hashCode(this.id);
    }

    public abstract String getSchedulerName();

    public abstract String getThreadNameSuffix();

    private boolean shouldProfile(ProfilingService profilingService) {
        return profilingService != null;
    }

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

