/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.management.stats;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.core.api.management.stats.ArtifactMeterProvider;
import org.mule.runtime.core.api.management.stats.ComponentStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.ResetOnQueryCounter;
import org.mule.runtime.core.internal.management.stats.DefaultResetOnQueryCounter;
import org.mule.runtime.metrics.api.meter.Meter;

public class DefaultFlowConstructStatistics
implements FlowConstructStatistics {
    private static final long serialVersionUID = 5337576392583767442L;
    public static final String FLOW_CONSTRUCT_STATISTICS_NAME = "flow.construct.statistics";
    public static final String FLOW_CONSTRUCT_STATISTICS_DESCRIPTION = "Flow Construct Statistics";
    public static final String RECEIVED_EVENTS_NAME = "received.events";
    public static final String RECEIVED_EVENTS_DESCRIPTION = "Received Events";
    public static final String DISPATCHED_MESSAGES_NAME = "dispatched.messages";
    public static final String DISPATCHED_MESSAGES_DESCRIPTION = "Dispatched Messages";
    public static final String EXECUTION_ERRORS_NAME = "execution.errors";
    public static final String EXECUTION_ERRORS_DESCRIPTION = "Execution Errors";
    public static final String FATAL_ERRORS_NAME = "fatal.errors";
    public static final String FATAL_ERRORS_DESCRIPTION = "Fatal Errors";
    protected final String flowConstructType;
    protected String name;
    protected boolean enabled = false;
    private long samplePeriod = 0L;
    protected final AtomicLong receivedEvents = new AtomicLong(0L);
    protected final AtomicLong dispatchedMessages = new AtomicLong(0L);
    private final AtomicLong executionError = new AtomicLong(0L);
    private final AtomicLong fatalError = new AtomicLong(0L);
    protected final ComponentStatistics flowStatistics = new ComponentStatistics();
    private final transient AtomicLong connectionErrors = new AtomicLong(0L);
    private final transient List<DefaultResetOnQueryCounter> eventsReceivedCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();
    private final transient List<DefaultResetOnQueryCounter> messagesDispatchedCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();
    private final transient List<DefaultResetOnQueryCounter> executionErrorsCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();
    private final transient List<DefaultResetOnQueryCounter> connectionErrorsCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();
    private final transient List<DefaultResetOnQueryCounter> fatalErrorsCounters = new CopyOnWriteArrayList<DefaultResetOnQueryCounter>();

    public DefaultFlowConstructStatistics(String flowConstructType, String name) {
        this.name = name;
        this.flowConstructType = flowConstructType;
        this.flowStatistics.setEnabled(this.enabled);
        if (this.getClass() == DefaultFlowConstructStatistics.class) {
            this.clear();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void incExecutionError() {
        if (this.isEnabled()) {
            this.executionError.addAndGet(1L);
            this.executionErrorsCounters.forEach(DefaultResetOnQueryCounter::increment);
        }
    }

    @Override
    public void incFatalError() {
        if (this.isEnabled()) {
            this.fatalError.addAndGet(1L);
            this.fatalErrorsCounters.forEach(DefaultResetOnQueryCounter::increment);
        }
    }

    @Override
    public synchronized void setEnabled(boolean b) {
        this.enabled = b;
        this.flowStatistics.setEnabled(this.enabled);
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    @Override
    public synchronized void clear() {
        this.receivedEvents.set(0L);
        this.dispatchedMessages.set(0L);
        this.samplePeriod = System.currentTimeMillis();
        this.executionError.set(0L);
        this.fatalError.set(0L);
        if (this.flowStatistics != null) {
            this.flowStatistics.clear();
        }
    }

    @Override
    public void addCompleteFlowExecutionTime(long time) {
        this.flowStatistics.addCompleteExecutionTime(time);
    }

    @Override
    public void addFlowExecutionBranchTime(long time, long total) {
        this.flowStatistics.addExecutionBranchTime(time == total, time, total);
    }

    @Override
    public long getAverageProcessingTime() {
        return this.flowStatistics.getAverageExecutionTime();
    }

    @Override
    public long getProcessedEvents() {
        return this.flowStatistics.getExecutedEvents();
    }

    @Override
    public long getMaxProcessingTime() {
        return this.flowStatistics.getMaxExecutionTime();
    }

    @Override
    public long getMinProcessingTime() {
        return this.flowStatistics.getMinExecutionTime();
    }

    @Override
    public long getTotalProcessingTime() {
        return this.flowStatistics.getTotalExecutionTime();
    }

    @Override
    public long getExecutionErrors() {
        return this.executionError.get();
    }

    @Override
    public long getFatalErrors() {
        return this.fatalError.get();
    }

    @Override
    public long getConnectionErrors() {
        return this.connectionErrors.get();
    }

    @Override
    public void incReceivedEvents() {
        if (this.isEnabled()) {
            this.receivedEvents.addAndGet(1L);
            this.eventsReceivedCounters.forEach(DefaultResetOnQueryCounter::increment);
        }
    }

    @Override
    public void incMessagesDispatched() {
        if (this.isEnabled()) {
            this.dispatchedMessages.addAndGet(1L);
            this.messagesDispatchedCounters.forEach(DefaultResetOnQueryCounter::increment);
        }
    }

    @Override
    public void incConnectionErrors() {
        if (this.isEnabled()) {
            this.connectionErrors.addAndGet(1L);
            this.connectionErrorsCounters.forEach(DefaultResetOnQueryCounter::increment);
        }
    }

    @Override
    public long getTotalEventsReceived() {
        return this.receivedEvents.get();
    }

    @Override
    public long getTotalDispatchedMessages() {
        return this.dispatchedMessages.get();
    }

    public long getSamplePeriod() {
        return System.currentTimeMillis() - this.samplePeriod;
    }

    @Override
    public ResetOnQueryCounter getEventsReceivedCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.eventsReceivedCounters.add(counter);
        counter.add(this.getTotalEventsReceived());
        return counter;
    }

    @Override
    public ResetOnQueryCounter getDispatchedMessagesCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.messagesDispatchedCounters.add(counter);
        counter.add(this.getTotalDispatchedMessages());
        return counter;
    }

    @Override
    public ResetOnQueryCounter getExecutionErrorsCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.executionErrorsCounters.add(counter);
        counter.add(this.getExecutionErrors());
        return counter;
    }

    @Override
    public ResetOnQueryCounter getConnectionErrorsCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.connectionErrorsCounters.add(counter);
        counter.add(this.getConnectionErrors());
        return counter;
    }

    @Override
    public ResetOnQueryCounter getFatalErrorsCounter() {
        DefaultResetOnQueryCounter counter = new DefaultResetOnQueryCounter();
        this.fatalErrorsCounters.add(counter);
        counter.add(this.getFatalErrors());
        return counter;
    }

    @Override
    public void trackUsingMeterProvider(ArtifactMeterProvider meterProvider) {
        String artifactId = this.getName() + "-" + meterProvider.getArtifactId();
        Meter meter = meterProvider.getMeterBuilder(FLOW_CONSTRUCT_STATISTICS_NAME).withDescription(FLOW_CONSTRUCT_STATISTICS_DESCRIPTION).withMeterAttribute("mule.artifact.id", artifactId).build();
        meter.counterBuilder(RECEIVED_EVENTS_NAME).withValueSupplier(this.receivedEvents::get).withConsumerForAddOperation(this.receivedEvents::addAndGet).withSupplierForIncrementAndGetOperation(this.receivedEvents::incrementAndGet).withDescription(RECEIVED_EVENTS_DESCRIPTION).build();
        meter.counterBuilder(DISPATCHED_MESSAGES_NAME).withValueSupplier(this.dispatchedMessages::get).withConsumerForAddOperation(this.dispatchedMessages::addAndGet).withSupplierForIncrementAndGetOperation(this.dispatchedMessages::incrementAndGet).withDescription(DISPATCHED_MESSAGES_DESCRIPTION).build();
        meter.counterBuilder(EXECUTION_ERRORS_NAME).withValueSupplier(this.executionError::get).withConsumerForAddOperation(this.executionError::addAndGet).withSupplierForIncrementAndGetOperation(this.executionError::incrementAndGet).withDescription(EXECUTION_ERRORS_DESCRIPTION).build();
        meter.counterBuilder(FATAL_ERRORS_NAME).withValueSupplier(this.fatalError::get).withConsumerForAddOperation(this.fatalError::addAndGet).withSupplierForIncrementAndGetOperation(this.fatalError::incrementAndGet).withDescription(FATAL_ERRORS_DESCRIPTION).build();
    }
}

