/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal.threads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.DefaultScheduler;
import org.mule.service.scheduler.internal.ThrottledScheduler;
import org.mule.service.scheduler.internal.executor.ByCallerThreadGroupPolicy;
import org.mule.service.scheduler.internal.executor.ByCallerThrottlingPolicy;
import org.mule.service.scheduler.internal.threads.SchedulerThreadFactory;
import org.mule.service.scheduler.internal.threads.SchedulerThreadPools;
import org.slf4j.Logger;

class DedicatedSchedulerThreadPools
extends SchedulerThreadPools {
    private static final String CPU_LIGHT_THREADS_NAME = ThreadType.CPU_LIGHT.getName();
    private static final String IO_THREADS_NAME = ThreadType.IO.getName();
    private static final String COMPUTATION_THREADS_NAME = ThreadType.CPU_INTENSIVE.getName();
    private ThreadGroup cpuLightGroup;
    private ThreadGroup ioGroup;
    private ThreadGroup computationGroup;
    private ThreadPoolExecutor cpuLightExecutor;
    private ThreadPoolExecutor ioExecutor;
    private ThreadPoolExecutor computationExecutor;
    private Predicate<ThreadGroup> cpuWorkChecker;
    private final List<Scheduler> activeCpuLightSchedulers = new ArrayList<Scheduler>();
    private final List<Scheduler> activeIoSchedulers = new ArrayList<Scheduler>();
    private final List<Scheduler> activeCpuIntensiveSchedulers = new ArrayList<Scheduler>();
    private Set<ThreadGroup> waitGroups;

    public DedicatedSchedulerThreadPools(String name, SchedulerPoolsConfig threadPoolsConfig, boolean preStartThreads, Consumer<AbstractExecutorService> preStartCallback, Logger traceLogger) {
        super(name, threadPoolsConfig, preStartThreads, preStartCallback, traceLogger);
    }

    @Override
    protected void doStart(boolean preStartThreads) throws MuleException {
        this.waitGroups = new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup, this.customCallerRunsAnsWaitGroup));
        this.cpuLightExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuLightPoolSize().getAsInt(), this.threadPoolsConfig.getCpuLightPoolSize().getAsInt(), 0L, TimeUnit.SECONDS, this.createQueue(this.threadPoolsConfig.getCpuLightQueueSize().getAsInt()), new SchedulerThreadFactory(this.cpuLightGroup), (RejectedExecutionHandler)this.byCallerThreadGroupPolicy.apply(this.cpuLightGroup.getName()));
        this.ioExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getIoCorePoolSize().getAsInt(), this.threadPoolsConfig.getIoMaxPoolSize().getAsInt(), this.threadPoolsConfig.getIoKeepAlive().getAsLong(), TimeUnit.MILLISECONDS, this.createQueue(this.threadPoolsConfig.getIoQueueSize().getAsInt()), new SchedulerThreadFactory(this.ioGroup), (RejectedExecutionHandler)this.byCallerThreadGroupPolicy.apply(this.ioGroup.getName()));
        this.computationExecutor = new ThreadPoolExecutor(this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt(), this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt(), 0L, TimeUnit.SECONDS, this.createQueue(this.threadPoolsConfig.getCpuIntensiveQueueSize().getAsInt()), new SchedulerThreadFactory(this.computationGroup), (RejectedExecutionHandler)this.byCallerThreadGroupPolicy.apply(this.computationGroup.getName()));
        if (preStartThreads) {
            this.prestartCoreThreads(this.cpuLightExecutor, this.threadPoolsConfig.getCpuLightPoolSize().getAsInt());
            this.prestartCoreThreads(this.ioExecutor, this.threadPoolsConfig.getIoCorePoolSize().getAsInt());
            this.prestartCoreThreads(this.computationExecutor, this.threadPoolsConfig.getCpuIntensivePoolSize().getAsInt());
        }
    }

    @Override
    public Scheduler createCpuLightScheduler(SchedulerConfig config, int parallelTasksEstimate, Supplier<Long> stopTimeout, ProfilingService profilingService) {
        this.validateCustomSchedulerOnlyConfigNotChanged(config);
        String schedulerName = this.resolveSchedulerName(config, CPU_LIGHT_THREADS_NAME);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getCpuLightPoolSize()) ? new ThrottledScheduler(schedulerName, this.cpuLightExecutor, parallelTasksEstimate, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, new ByCallerThrottlingPolicy(config.getMaxConcurrentTasks(), new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)), this.parentGroup, this.traceLogger), stopTimeout, this.shutdownCallback(this.activeCpuLightSchedulers), profilingService) : new DefaultScheduler(schedulerName, this.cpuLightExecutor, parallelTasksEstimate, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_LIGHT, stopTimeout, this.shutdownCallback(this.activeCpuLightSchedulers), profilingService);
        this.addScheduler(this.activeCpuLightSchedulers, scheduler);
        return scheduler;
    }

    @Override
    public Scheduler createIoScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, ProfilingService profilingService) {
        this.validateCustomSchedulerOnlyConfigNotChanged(config);
        String schedulerName = this.resolveSchedulerName(config, IO_THREADS_NAME);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getIoMaxPoolSize()) ? new ThrottledScheduler(schedulerName, this.ioExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, new ByCallerThrottlingPolicy(config.getMaxConcurrentTasks(), new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)), this.parentGroup, this.traceLogger), stopTimeout, this.shutdownCallback(this.activeIoSchedulers), profilingService) : new DefaultScheduler(schedulerName, this.ioExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.IO, stopTimeout, this.shutdownCallback(this.activeIoSchedulers), profilingService);
        this.addScheduler(this.activeIoSchedulers, scheduler);
        return scheduler;
    }

    @Override
    public Scheduler createCpuIntensiveScheduler(SchedulerConfig config, int workers, Supplier<Long> stopTimeout, ProfilingService profilingService) {
        this.validateCustomSchedulerOnlyConfigNotChanged(config);
        String schedulerName = this.resolveSchedulerName(config, COMPUTATION_THREADS_NAME);
        DefaultScheduler scheduler = this.shouldThrottle(config, this.threadPoolsConfig.getCpuIntensivePoolSize()) ? new ThrottledScheduler(schedulerName, this.computationExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, new ByCallerThrottlingPolicy(config.getMaxConcurrentTasks(), new HashSet<ThreadGroup>(Arrays.asList(this.ioGroup, this.customWaitGroup)), this.parentGroup, this.traceLogger), stopTimeout, this.shutdownCallback(this.activeCpuIntensiveSchedulers), profilingService) : new DefaultScheduler(schedulerName, this.computationExecutor, workers, this.scheduledExecutor, this.quartzScheduler, ThreadType.CPU_INTENSIVE, stopTimeout, this.shutdownCallback(this.activeCpuIntensiveSchedulers), profilingService);
        this.addScheduler(this.activeCpuIntensiveSchedulers, scheduler);
        return scheduler;
    }

    @Override
    protected void createCustomThreadGroups() {
        this.cpuLightGroup = new ThreadGroup(this.parentGroup, this.threadPoolsConfig.getThreadNamePrefix() + CPU_LIGHT_THREADS_NAME);
        this.ioGroup = new ThreadGroup(this.parentGroup, this.threadPoolsConfig.getThreadNamePrefix() + IO_THREADS_NAME);
        this.computationGroup = new ThreadGroup(this.parentGroup, this.threadPoolsConfig.getThreadNamePrefix() + COMPUTATION_THREADS_NAME);
        HashSet<ThreadGroup> cpuWorkGroups = new HashSet<ThreadGroup>(Arrays.asList(this.cpuLightGroup, this.computationGroup));
        this.cpuWorkChecker = threadGroup -> {
            if (threadGroup != null) {
                while (threadGroup.getParent() != null) {
                    if (cpuWorkGroups.contains(threadGroup)) {
                        return true;
                    }
                    threadGroup = threadGroup.getParent();
                }
            }
            return false;
        };
    }

    @Override
    protected ByCallerThreadGroupPolicy createThreadGroupPolicy(String schedulerName) {
        return new ByCallerThreadGroupPolicy(this.waitGroups, new HashSet<ThreadGroup>(Arrays.asList(this.cpuLightGroup, this.computationGroup, this.customCallerRunsGroup, this.customCallerRunsAnsWaitGroup)), this.cpuLightGroup, this.parentGroup, schedulerName, this.traceLogger);
    }

    @Override
    protected ThreadPoolExecutor getCustomSchedulerDestroyerExecutor() {
        return this.ioExecutor;
    }

    @Override
    protected Set<ThreadGroup> getWaitGroups() {
        return this.waitGroups;
    }

    @Override
    protected void shutdownPools() throws MuleException, InterruptedException {
        this.cpuLightExecutor.shutdown();
        this.ioExecutor.shutdown();
        this.computationExecutor.shutdown();
    }

    @Override
    protected void waitForExecutorTermination(long shutdownStartMillis) throws InterruptedException {
        this.waitForExecutorTermination(shutdownStartMillis, this.cpuLightExecutor, this.threadPoolsConfig.getThreadNamePrefix() + CPU_LIGHT_THREADS_NAME);
        this.waitForExecutorTermination(shutdownStartMillis, this.ioExecutor, this.threadPoolsConfig.getThreadNamePrefix() + IO_THREADS_NAME);
        this.waitForExecutorTermination(shutdownStartMillis, this.computationExecutor, this.threadPoolsConfig.getThreadNamePrefix() + COMPUTATION_THREADS_NAME);
    }

    @Override
    protected void onStopCompleted() {
        this.cpuLightExecutor = null;
        this.ioExecutor = null;
        this.computationExecutor = null;
    }

    @Override
    public boolean isCurrentThreadForCpuWork() {
        return this.cpuWorkChecker.test(Thread.currentThread().getThreadGroup());
    }

    @Override
    protected List<Scheduler> getOwnSchedulers() {
        LinkedList<Scheduler> schedulers = new LinkedList<Scheduler>();
        schedulers.addAll(this.activeCpuLightSchedulers);
        schedulers.addAll(this.activeIoSchedulers);
        schedulers.addAll(this.activeCpuIntensiveSchedulers);
        return schedulers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String buildReportString() {
        int schedulersCustom;
        int schedulersCpuIntensive;
        int schedulersIo;
        int schedulersCpuLight;
        StringBuilder threadPoolsReportBuilder = new StringBuilder();
        this.activeSchedulersReadLock.lock();
        try {
            schedulersCpuLight = this.activeCpuLightSchedulers.size();
            schedulersIo = this.activeIoSchedulers.size();
            schedulersCpuIntensive = this.activeCpuIntensiveSchedulers.size();
            schedulersCustom = this.activeCustomSchedulers.size();
        }
        finally {
            this.activeSchedulersReadLock.unlock();
        }
        int cpuLightActiveCount = this.cpuLightExecutor.getActiveCount();
        long cpuLightTaskCount = this.cpuLightExecutor.getTaskCount();
        long cpuLightRejected = ((ByCallerThreadGroupPolicy)this.cpuLightExecutor.getRejectedExecutionHandler()).getRejectedCount();
        int ioActiveCount = this.ioExecutor.getActiveCount();
        long ioTaskCount = this.ioExecutor.getTaskCount();
        long ioRejected = ((ByCallerThreadGroupPolicy)this.ioExecutor.getRejectedExecutionHandler()).getRejectedCount();
        int cpuIntensiveActiveCount = this.computationExecutor.getActiveCount();
        long cpuIntensiveTaskCount = this.computationExecutor.getTaskCount();
        long cpuIntensiveRejected = ((ByCallerThreadGroupPolicy)this.computationExecutor.getRejectedExecutionHandler()).getRejectedCount();
        int customActiveCount = 0;
        int customUsedCount = 0;
        int customQueued = 0;
        long customTaskCount = 0L;
        long customRejected = 0L;
        for (ThreadPoolExecutor customExecutor : this.customSchedulersExecutors) {
            int currentCustomActive = customExecutor.getActiveCount();
            customActiveCount += currentCustomActive;
            customUsedCount += customExecutor.getPoolSize() - currentCustomActive;
            customQueued += customExecutor.getQueue().size();
            customTaskCount += customExecutor.getTaskCount();
            customRejected += ((ByCallerThreadGroupPolicy)customExecutor.getRejectedExecutionHandler()).getRejectedCount();
        }
        threadPoolsReportBuilder.append(System.lineSeparator() + this.name + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator());
        threadPoolsReportBuilder.append("Pool          | Schedulers | Idle threads | Used threads | Queued tasks | Rejection % " + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("CPU Light     | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersCpuLight, this.cpuLightExecutor.getPoolSize() - cpuLightActiveCount, cpuLightActiveCount, this.cpuLightExecutor.getQueue().size(), cpuLightRejected > 0L ? 100.0 * (double)(cpuLightRejected / (cpuLightTaskCount + cpuLightRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("IO            | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersIo, this.ioExecutor.getPoolSize() - ioActiveCount, ioActiveCount, this.ioExecutor.getQueue().size(), ioRejected > 0L ? 100.0 * (double)(ioRejected / (ioTaskCount + ioRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("CPU Intensive | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersCpuIntensive, this.computationExecutor.getPoolSize() - cpuIntensiveActiveCount, cpuIntensiveActiveCount, this.computationExecutor.getQueue().size(), cpuIntensiveRejected > 0L ? 100.0 * (double)(cpuIntensiveRejected / (cpuIntensiveTaskCount + cpuIntensiveRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append(String.format("Custom        | %10d | %12d | %12d | %12d | ~ %9.2f", schedulersCustom, customUsedCount, customActiveCount, customQueued, customRejected > 0L ? 100.0 * (double)(customRejected / (customTaskCount + customRejected)) : 0.0) + System.lineSeparator());
        threadPoolsReportBuilder.append("--------------------------------------------------------------------------------------" + System.lineSeparator() + System.lineSeparator());
        return threadPoolsReportBuilder.toString();
    }
}

