/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.logging;

import org.togglz.core.Feature;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class LoggingStateRepository
implements StateRepository {
    private final Log log;
    private final StateRepository delegate;
    private String customLogMessage;

    public LoggingStateRepository(StateRepository delegate) {
        this(delegate, LogFactory.getLog(LoggingStateRepository.class));
    }

    public LoggingStateRepository(StateRepository delegate, String customLogMessage) {
        this(delegate, customLogMessage, LogFactory.getLog(LoggingStateRepository.class));
    }

    protected LoggingStateRepository(StateRepository delegate, Log log) {
        this.delegate = delegate;
        this.log = log;
    }

    protected LoggingStateRepository(StateRepository delegate, String customLogMessage, Log log) {
        this.delegate = delegate;
        this.log = log;
        this.customLogMessage = customLogMessage;
    }

    @Override
    public FeatureState getFeatureState(Feature feature) {
        return this.delegate.getFeatureState(feature);
    }

    @Override
    public void setFeatureState(FeatureState featureState) {
        if (this.customLogMessage != null) {
            this.log.info(this.createCustomLogMessage(featureState));
        } else {
            this.log.info(this.createDefaultLogMessage(featureState));
        }
        this.delegate.setFeatureState(featureState);
    }

    private String createDefaultLogMessage(FeatureState featureState) {
        return "Setting Feature \"" + featureState.getFeature().name() + "\" to \"" + this.getReadableFeatureState(featureState) + "\"";
    }

    private String createCustomLogMessage(FeatureState featureState) {
        String logMsg = this.customLogMessage;
        logMsg = logMsg.replace("{1}", featureState.getFeature().name());
        logMsg = logMsg.replace("{2}", this.getReadableFeatureState(featureState));
        return logMsg;
    }

    private String getReadableFeatureState(FeatureState featureState) {
        return featureState.isEnabled() ? "enabled" : "disabled";
    }
}

