/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository.composite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class CompositeStateRepository
implements StateRepository {
    private final List<StateRepository> repositories;
    private RepositorySelector iterationOrder = IterationOrder.FIFO;
    private RepositorySelector setterSelection = SetterSelection.LAST;

    public CompositeStateRepository(StateRepository ... repositories) {
        this.repositories = Arrays.asList(repositories);
    }

    public void setIterationOrder(RepositorySelector iterationOrder) {
        this.iterationOrder = iterationOrder;
    }

    public void setSetterSelection(RepositorySelector setterSelection) {
        this.setterSelection = setterSelection;
    }

    @Override
    public FeatureState getFeatureState(Feature feature) {
        for (StateRepository repository : this.iterationOrder.getSelected(this.repositories)) {
            FeatureState featureState = repository.getFeatureState(feature);
            if (featureState == null) continue;
            return featureState;
        }
        return null;
    }

    @Override
    public void setFeatureState(FeatureState featureState) {
        for (StateRepository repository : this.setterSelection.getSelected(this.repositories)) {
            repository.setFeatureState(featureState);
        }
    }

    public static enum SetterSelection implements RepositorySelector
    {
        FIRST{

            @Override
            public List<StateRepository> getSelected(List<StateRepository> from) {
                return SetterSelection.get(from, 0);
            }
        }
        ,
        LAST{

            @Override
            public List<StateRepository> getSelected(List<StateRepository> from) {
                return SetterSelection.get(from, from.size() - 1);
            }
        }
        ,
        ALL{

            @Override
            public List<StateRepository> getSelected(List<StateRepository> from) {
                return from;
            }
        };


        private static List<StateRepository> get(List<StateRepository> from, int index) {
            ArrayList<StateRepository> result = new ArrayList<StateRepository>(1);
            result.add(from.get(index));
            return result;
        }
    }

    public static enum IterationOrder implements RepositorySelector
    {
        FIFO{

            @Override
            public List<StateRepository> getSelected(List<StateRepository> from) {
                return new ArrayList<StateRepository>(from);
            }
        }
        ,
        LIFO{

            @Override
            public List<StateRepository> getSelected(List<StateRepository> from) {
                ArrayList<StateRepository> result = new ArrayList<StateRepository>(from);
                Collections.reverse(result);
                return result;
            }
        };

    }

    public static interface RepositorySelector {
        public List<StateRepository> getSelected(List<StateRepository> var1);
    }
}

