/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultArgumentDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class EventDumpOperation
implements TroubleshootingOperation {
    public static final String EVENT_DUMP_OPERATION_NAME = "events";
    public static final String EVENT_DUMP_OPERATION_DESCRIPTION = "Collects an EventDump of currently active events";
    public static final String APPLICATION_ARGUMENT_NAME = "application";
    public static final String APPLICATION_ARGUMENT_DESCRIPTION = "Application to collect the event dump from";
    private static final TroubleshootingOperationDefinition definition = EventDumpOperation.createOperationDefinition();
    private final DeploymentService deploymentService;

    public EventDumpOperation(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            String applicationName = (String)arguments.get(APPLICATION_ARGUMENT_NAME);
            if (applicationName == null) {
                this.writeFlowStacksForAllApplications(writer);
            } else {
                Application application = this.deploymentService.findApplication(applicationName);
                EventDumpOperation.writeFlowStackEntries(application, writer);
            }
        };
    }

    private static void writeFlowStacksFor(Application application, Writer writer) throws IOException {
        String appsTitle = "Active Events for application '" + application.getArtifactName() + "'";
        writer.write(appsTitle + System.lineSeparator());
        writer.write(StringUtils.leftPad((String)"", (int)appsTitle.length(), (String)"-") + System.lineSeparator());
        writer.write(System.lineSeparator());
        EventDumpOperation.writeFlowStackEntries(application, writer);
    }

    private void writeFlowStacksForAllApplications(Writer writer) throws IOException {
        for (Application application : this.deploymentService.getApplications()) {
            EventDumpOperation.writeFlowStacksFor(application, writer);
        }
    }

    private static void writeFlowStackEntries(Application application, Writer writer) throws IOException {
        EventContextService eventContextService = application.getArtifactContext().getRegistry().lookupByName("_muleEventContextService").map(EventContextService.class::cast).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get EventContextService for application %s.", application.getArtifactName())));
        List currentlyActiveFlowStacks = eventContextService.getCurrentlyActiveFlowStacks();
        for (EventContextService.FlowStackEntry fs : currentlyActiveFlowStacks) {
            writer.write(String.format("\"%s\"%n%s", fs.getEventId(), Arrays.stream(StringUtils.split((String)fs.getFlowCallStack().toString(), (String)System.lineSeparator())).map(s -> "    " + s).collect(Collectors.joining(System.lineSeparator(), "", System.lineSeparator()))));
            writer.write(System.lineSeparator());
        }
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(EVENT_DUMP_OPERATION_NAME, EVENT_DUMP_OPERATION_DESCRIPTION, EventDumpOperation.createApplicationArgumentDefinition());
    }

    private static ArgumentDefinition createApplicationArgumentDefinition() {
        return new DefaultArgumentDefinition(APPLICATION_ARGUMENT_NAME, APPLICATION_ARGUMENT_DESCRIPTION, false);
    }
}

