/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;

public class BasicInfoOperation
implements TroubleshootingOperation {
    public static final String BASIC_INFO_OPERATION_NAME = "basicInfo";
    public static final String BASIC_INFO_OPERATION_DESCRIPTION = "Collects basic environment and metadata information for the current Mule Runtime";
    private static final TroubleshootingOperationDefinition definition = BasicInfoOperation.createOperationDefinition();

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            writer.write("Mule:" + System.lineSeparator());
            writer.write(String.format("  %s %s (build %s)", MuleManifest.getProductName(), MuleManifest.getProductVersion(), MuleManifest.getBuildNumber()) + System.lineSeparator());
            writer.write(String.format("  mule_home: %s", MuleFoldersUtil.getMuleHomeFolder().getAbsolutePath()) + System.lineSeparator());
            writer.write(String.format("  mule_base: %s", MuleFoldersUtil.getMuleBaseFolder().getAbsolutePath()) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("System Properties:" + System.lineSeparator());
            Map muleProperties = System.getProperties().stringPropertyNames().stream().filter(property -> property.startsWith("mule.")).collect(Collectors.toMap(UnaryOperator.identity(), System::getProperty, (v1, v2) -> v1, TreeMap::new));
            for (Map.Entry entry : muleProperties.entrySet()) {
                writer.write(String.format("  %s: %s", entry.getKey(), entry.getValue()) + System.lineSeparator());
            }
            writer.write(System.lineSeparator());
            writer.write("Java:" + System.lineSeparator());
            writer.write(String.format("  Version:   %s", System.getProperty("java.version")) + System.lineSeparator());
            writer.write(String.format("  Vendor:    %s", System.getProperty("java.vendor")) + System.lineSeparator());
            writer.write(String.format("  VM name:   %s", System.getProperty("java.vm.name")) + System.lineSeparator());
            writer.write(String.format("  JAVA_HOME: %s", System.getProperty("java.home")) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("OS:" + System.lineSeparator());
            writer.write(String.format("  Name:      %s", System.getProperty("os.name")) + System.lineSeparator());
            writer.write(String.format("  Version:   %s", System.getProperty("os.version")) + System.lineSeparator());
            writer.write(String.format("  Arch:      %s", System.getProperty("os.arch")) + System.lineSeparator());
            writer.write(System.lineSeparator());
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            writer.write(String.format("Running time: %s", DurationFormatUtils.formatDuration((long)runtimeMxBean.getUptime(), (String)"d'd' HH:mm:ss.SSS")));
            writer.write(System.lineSeparator());
        };
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(BASIC_INFO_OPERATION_NAME, BASIC_INFO_OPERATION_DESCRIPTION, new ArgumentDefinition[0]);
    }
}

