/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.testing.assertj.TraceAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractIterableAssert;

public final class TracesAssert
extends AbstractIterableAssert<TracesAssert, List<List<SpanData>>, List<SpanData>, TraceAssert> {
    static final Comparator<SpanData> SPAN_DATA_COMPARATOR = Comparator.comparing(SpanData::getStartEpochNanos).thenComparing((span1, span2) -> {
        SpanContext parent1 = span1.getParentSpanContext();
        if (parent1.isValid() && parent1.getSpanId().equals(span2.getSpanId())) {
            return 1;
        }
        SpanContext parent2 = span2.getParentSpanContext();
        if (parent2.isValid() && parent2.getSpanId().equals(span1.getSpanId())) {
            return -1;
        }
        return 0;
    });

    public static TracesAssert assertThat(List<SpanData> spanData) {
        Map traces = spanData.stream().collect(Collectors.groupingBy(SpanData::getTraceId, LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        for (List trace : traces.values()) {
            trace.sort(SPAN_DATA_COMPARATOR);
        }
        return TracesAssert.assertThat(traces.values());
    }

    public static TracesAssert assertThat(Collection<List<SpanData>> traces) {
        for (List<SpanData> trace : traces) {
            if (trace.stream().map(SpanData::getTraceId).distinct().count() == 1L) continue;
            throw new IllegalArgumentException("trace does not have consistent trace IDs, group spans into traces before calling this function: " + trace);
        }
        return new TracesAssert(new ArrayList<List<SpanData>>(traces));
    }

    TracesAssert(List<List<SpanData>> lists) {
        super(lists, TracesAssert.class);
    }

    @SafeVarargs
    public final TracesAssert hasTracesSatisfyingExactly(Consumer<TraceAssert> ... assertions) {
        return this.hasTracesSatisfyingExactly(Arrays.asList(assertions));
    }

    public TracesAssert hasTracesSatisfyingExactly(Iterable<? extends Consumer<TraceAssert>> assertions) {
        List assertionsList = StreamSupport.stream(assertions.spliterator(), false).collect(Collectors.toList());
        this.hasSize(assertionsList.size());
        for (int i = 0; i < assertionsList.size(); ++i) {
            ((Consumer)assertionsList.get(i)).accept(new TraceAssert((List)((List)this.actual).get(i)));
        }
        return this;
    }

    protected TraceAssert toAssert(List<SpanData> value, String description) {
        return (TraceAssert)new TraceAssert(value).as(description, new Object[0]);
    }

    protected TracesAssert newAbstractIterableAssert(Iterable<? extends List<SpanData>> iterable) {
        return new TracesAssert(StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()));
    }
}

