/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class DefaultEventContextService
implements EventContextService {
    private final Set<DefaultEventContext> currentContexts = ConcurrentHashMap.newKeySet(512);

    @Override
    public List<EventContextService.FlowStackEntry> getCurrentlyActiveFlowStacks() {
        Instant now = Instant.now();
        ArrayList<EventContextService.FlowStackEntry> flowStacks = new ArrayList<EventContextService.FlowStackEntry>();
        for (DefaultEventContext context : this.currentContexts) {
            flowStacks.add(new DefaultFlowStackEntry(context, now));
            context.forEachChild(childContext -> flowStacks.add(new DefaultFlowStackEntry((BaseEventContext)childContext, now)));
        }
        return flowStacks;
    }

    public void addContext(DefaultEventContext context) {
        this.currentContexts.add(context);
    }

    public void removeContext(DefaultEventContext context) {
        this.currentContexts.remove(context);
    }

    private static final class DefaultFlowStackEntry
    implements EventContextService.FlowStackEntry {
        private final String serverId;
        private final String eventId;
        private final EventContextService.EventContextState state;
        private final Duration executingTime;
        private final String originatingLocation;
        private final FlowCallStack flowCallStack;

        public DefaultFlowStackEntry(BaseEventContext context, Instant now) {
            this.serverId = context.getServerId();
            this.eventId = context.getId();
            this.state = context.isTerminated() ? EventContextService.EventContextState.TERMINATED : (context.isComplete() ? EventContextService.EventContextState.COMPLETE : (context.isResponseDone() ? EventContextService.EventContextState.RESPONSE_PROCESSED : EventContextService.EventContextState.EXECUTING));
            this.executingTime = Duration.between(context.getStartTime(), now);
            this.originatingLocation = context.getOriginatingLocation().getLocation();
            this.flowCallStack = context.getFlowCallStack().clone();
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getEventId() {
            return this.eventId;
        }

        @Override
        public EventContextService.EventContextState getState() {
            return this.state;
        }

        @Override
        public Duration getExecutingTime() {
            return this.executingTime;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.flowCallStack;
        }

        public String toString() {
            return "eventId: " + this.eventId + " @ " + this.originatingLocation + ";" + System.lineSeparator() + this.getFlowCallStack().toString();
        }
    }
}

