/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.declaration.type.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;

public class StereotypeTypeAnnotation
implements TypeAnnotation {
    public static final String NAME = "stereotype";
    private final List<StereotypeModel> allowedStereotypes;
    private transient List<Class<? extends org.mule.sdk.api.stereotype.StereotypeDefinition>> definitionClasses;
    private transient List<Class<? extends StereotypeDefinition>> legacyDefinitions;

    public static StereotypeTypeAnnotation fromDefinitions(List<Class<? extends StereotypeDefinition>> definitionClasses) {
        StereotypeTypeAnnotation annotation = new StereotypeTypeAnnotation(new ArrayList<StereotypeModel>(definitionClasses.size()));
        annotation.legacyDefinitions = definitionClasses;
        annotation.definitionClasses = Collections.emptyList();
        return annotation;
    }

    public static StereotypeTypeAnnotation fromAllowedDefinitions(List<Class<? extends org.mule.sdk.api.stereotype.StereotypeDefinition>> definitionClasses) {
        StereotypeTypeAnnotation annotation = new StereotypeTypeAnnotation(new ArrayList<StereotypeModel>(definitionClasses.size()));
        annotation.definitionClasses = definitionClasses;
        annotation.legacyDefinitions = Collections.emptyList();
        return annotation;
    }

    public StereotypeTypeAnnotation(List<StereotypeModel> allowedStereotypes) {
        this.allowedStereotypes = allowedStereotypes;
    }

    public List<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public void resolveAllowedStereotypes(Function<Class<? extends org.mule.sdk.api.stereotype.StereotypeDefinition>, StereotypeModel> resolver, Function<Class<? extends StereotypeDefinition>, StereotypeModel> legacyResolver) {
        if (this.allowedStereotypes.isEmpty()) {
            this.definitionClasses.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)resolver.apply((Class<? extends org.mule.sdk.api.stereotype.StereotypeDefinition>)clazz)));
            this.legacyDefinitions.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)legacyResolver.apply((Class<? extends StereotypeDefinition>)clazz)));
        }
    }

    public void resolveAllowedStereotypes(ObjectType objectType, BiFunction<ObjectType, Class<? extends org.mule.sdk.api.stereotype.StereotypeDefinition>, StereotypeModel> resolver, BiFunction<ObjectType, Class<? extends StereotypeDefinition>, StereotypeModel> legacyResolver) {
        if (this.allowedStereotypes.isEmpty()) {
            this.definitionClasses.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)resolver.apply(objectType, (Class<? extends org.mule.sdk.api.stereotype.StereotypeDefinition>)clazz)));
            this.legacyDefinitions.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)legacyResolver.apply(objectType, (Class<? extends StereotypeDefinition>)clazz)));
        }
    }

    @Deprecated
    public void resolveStereotypes(Function<Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
        if (this.allowedStereotypes.isEmpty()) {
            this.legacyDefinitions.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)resolver.apply((Class<? extends StereotypeDefinition>)clazz)));
        }
    }

    @Deprecated
    public void resolveStereotypes(ObjectType objectType, BiFunction<ObjectType, Class<? extends StereotypeDefinition>, StereotypeModel> resolver) {
        if (this.allowedStereotypes.isEmpty()) {
            this.legacyDefinitions.forEach(clazz -> this.allowedStereotypes.add((StereotypeModel)resolver.apply(objectType, (Class<? extends StereotypeDefinition>)clazz)));
        }
    }

    public String getName() {
        return NAME;
    }

    public boolean isPublic() {
        return true;
    }

    public int hashCode() {
        return this.allowedStereotypes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StereotypeTypeAnnotation other = (StereotypeTypeAnnotation)obj;
        return !(this.allowedStereotypes == null ? other.allowedStereotypes != null : !this.allowedStereotypes.equals(other.allowedStereotypes));
    }
}

