/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle.phases;

import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.PostConstruct;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.Component;
import org.mule.runtime.core.api.config.Config;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.lifecycle.phases.DefaultLifecyclePhase;
import org.mule.runtime.core.privileged.routing.OutboundRouter;
import org.mule.runtime.core.privileged.util.annotation.AnnotationMetaData;
import org.mule.runtime.core.privileged.util.annotation.AnnotationUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class MuleContextInitialisePhase
extends DefaultLifecyclePhase {
    public MuleContextInitialisePhase() {
        super("initialise", LifecycleUtils::initialiseIfNeeded);
        this.registerSupportedPhase("not in lifecycle");
        this.setOrderedLifecycleTypes(new Class[]{StreamingManager.class, ObjectStore.class, ExpressionLanguage.class, ConfigurationProvider.class, Config.class, SecurityManager.class, FlowConstruct.class, Initialisable.class});
        this.setIgnoredObjectTypes(new Class[]{Component.class, InterceptingMessageProcessor.class, OutboundRouter.class, MuleContext.class, ObjectProvider.class});
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        super.applyLifecycle(o);
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        List<AnnotationMetaData> annos = AnnotationUtils.getMethodAnnotations(o.getClass(), PostConstruct.class);
        if (annos.size() == 1) {
            AnnotationMetaData anno = annos.get(0);
            try {
                ((Method)anno.getMember()).invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(anno.getMember().getName(), o), (Throwable)e, (Object)this);
            }
        }
    }
}

