/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.shadow.org.terracotta.offheapstore.concurrent;

import org.ehcache.shadow.org.terracotta.offheapstore.WriteLockedOffHeapHashMap;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.PageSource;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.StorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;

public class WriteLockedOffHeapHashMapFactory<K, V>
implements Factory<WriteLockedOffHeapHashMap<K, V>> {
    private static final int DEFAULT_TABLE_SIZE = 128;
    private final Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;

    public WriteLockedOffHeapHashMapFactory(PageSource tableSource, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory) {
        this(tableSource, storageEngineFactory, 128);
    }

    public WriteLockedOffHeapHashMapFactory(PageSource tableSource, Factory<? extends StorageEngine<? super K, ? super V>> storageEngineFactory, int tableSize) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = tableSource;
        this.tableSize = tableSize;
    }

    @Override
    public WriteLockedOffHeapHashMap<K, V> newInstance() {
        StorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new WriteLockedOffHeapHashMap<K, V>(this.tableSource, storageEngine, this.tableSize);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }
}

