/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.ComposedErrorException;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.exception.MessagingException;

public final class ChainErrorHandlingUtils {
    private ChainErrorHandlingUtils() {
    }

    public static BiFunction<Throwable, Object, Throwable> getLocalOperatorErrorHook(Processor processor, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders) {
        MessagingExceptionResolver exceptionResolver = processor instanceof Component ? new MessagingExceptionResolver((Component)processor) : null;
        Function<MessagingException, MessagingException> messagingExceptionMapper = ChainErrorHandlingUtils.resolveMessagingException(processor, e -> exceptionResolver.resolve((MessagingException)((Object)e), locator, exceptionContextProviders));
        return (throwable, event) -> {
            throwable = Exceptions.unwrap(throwable);
            if (event instanceof CoreEvent) {
                if (throwable instanceof MessagingException) {
                    return (Throwable)messagingExceptionMapper.apply((MessagingException)((Object)((Object)throwable)));
                }
                return ChainErrorHandlingUtils.resolveException(processor, (CoreEvent)event, throwable, locator, exceptionContextProviders, exceptionResolver);
            }
            return throwable;
        };
    }

    static MessagingException resolveException(Processor processor, CoreEvent event, Throwable throwable, ErrorTypeLocator locator, Collection<ExceptionContextProvider> exceptionContextProviders, MessagingExceptionResolver exceptionResolver) {
        if (event.getError().isPresent()) {
            event = CoreEvent.builder(event).error(null).build();
        }
        if (processor instanceof Component) {
            return exceptionResolver.resolve(new MessagingException(event, throwable, (Component)processor), locator, exceptionContextProviders);
        }
        return new MessagingException(event, throwable);
    }

    static Function<MessagingException, MessagingException> resolveMessagingException(Processor processor, Function<MessagingException, MessagingException> messagingExceptionMapper) {
        if (processor instanceof Component) {
            return exception -> {
                if (!exception.getEvent().getError().isPresent() || exception.getCause() instanceof RetryPolicyExhaustedException || exception.getCause() instanceof ComposedErrorException) {
                    return (MessagingException)((Object)((Object)messagingExceptionMapper.apply((MessagingException)((Object)exception))));
                }
                return exception;
            };
        }
        return Function.identity();
    }

    static Error resolveError(EventProcessingException exception, ErrorTypeLocator errorTypeLocator) {
        ErrorType errorType = Optional.ofNullable(exception.getExceptionInfo().getErrorType()).orElse(errorTypeLocator.lookupErrorType((Throwable)ExceptionHelper.getRootMuleException((Throwable)((Object)exception))));
        return exception.getEvent().getError().orElseGet(() -> ErrorBuilder.builder().exception((Throwable)((Object)exception)).description(exception.getMessage()).detailedDescription(exception.getDetailedMessage()).errorType(errorType).failingComponent(exception.getFailingComponent()).build());
    }
}

