/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;

class ObjectSchemaLoader {
    private final LoadingState ls;
    private final SchemaLoader defaultLoader;

    public ObjectSchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    ObjectSchema.Builder load() {
        JSONObject patternPropsJson;
        String[] patterns;
        ObjectSchema.Builder builder = ObjectSchema.builder();
        this.ls.ifPresent("minProperties", Integer.class, builder::minProperties);
        this.ls.ifPresent("maxProperties", Integer.class, builder::maxProperties);
        if (this.ls.schemaJson.has("properties")) {
            this.ls.typeMultiplexer(this.ls.schemaJson.get("properties")).ifObject().then(propertyDefs -> this.populatePropertySchemas((JSONObject)propertyDefs, builder)).requireAny();
        }
        if (this.ls.schemaJson.has("additionalProperties")) {
            this.ls.typeMultiplexer("additionalProperties", this.ls.schemaJson.get("additionalProperties")).ifIs(Boolean.class).then(builder::additionalProperties).ifObject().then(def -> builder.schemaOfAdditionalProperties((Schema)this.defaultLoader.loadChild((JSONObject)def).build())).requireAny();
        }
        if (this.ls.schemaJson.has("required")) {
            JSONArray requiredJson = this.ls.schemaJson.getJSONArray("required");
            IntStream.range(0, requiredJson.length()).mapToObj(arg_0 -> ((JSONArray)requiredJson).getString(arg_0)).forEach(builder::addRequiredProperty);
        }
        if (this.ls.schemaJson.has("patternProperties") && (patterns = JSONObject.getNames((JSONObject)(patternPropsJson = this.ls.schemaJson.getJSONObject("patternProperties")))) != null) {
            for (String pattern : patterns) {
                builder.patternProperty(pattern, (Schema)this.defaultLoader.loadChild(patternPropsJson.getJSONObject(pattern)).build());
            }
        }
        this.ls.ifPresent("dependencies", JSONObject.class, deps -> this.addDependencies(builder, (JSONObject)deps));
        return builder;
    }

    private void populatePropertySchemas(JSONObject propertyDefs, ObjectSchema.Builder builder) {
        String[] names = JSONObject.getNames((JSONObject)propertyDefs);
        if (names == null || names.length == 0) {
            return;
        }
        Arrays.stream(names).forEach(key -> this.addPropertySchemaDefinition((String)key, propertyDefs.get(key), builder));
    }

    private void addPropertySchemaDefinition(String keyOfObj, Object definition, ObjectSchema.Builder builder) {
        this.ls.typeMultiplexer(definition).ifObject().then(obj -> builder.addPropertySchema(keyOfObj, (Schema)this.defaultLoader.loadChild((JSONObject)obj).build())).requireAny();
    }

    private void addDependencies(ObjectSchema.Builder builder, JSONObject deps) {
        Arrays.stream(JSONObject.getNames((JSONObject)deps)).forEach(ifPresent -> this.addDependency(builder, (String)ifPresent, deps.get(ifPresent)));
    }

    private void addDependency(ObjectSchema.Builder builder, String ifPresent, Object deps) {
        this.ls.typeMultiplexer(deps).ifObject().then(obj -> builder.schemaDependency(ifPresent, (Schema)this.defaultLoader.loadChild((JSONObject)obj).build())).ifIs(JSONArray.class).then(propNames -> IntStream.range(0, propNames.length()).mapToObj(i -> propNames.getString(i)).forEach(dependency -> builder.propertyDependency(ifPresent, (String)dependency))).requireAny();
    }
}

