/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.el.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.el.context.AbstractMapContext;

public final class EventVariablesMapContext
extends AbstractMapContext<Object> {
    private CoreEvent event;
    private CoreEvent.Builder eventBuider;

    public EventVariablesMapContext(CoreEvent event, CoreEvent.Builder eventBuider) {
        this.event = event;
        this.eventBuider = eventBuider;
    }

    @Override
    public Object doGet(String key) {
        return CoreEvent.getVariableValueOrNull((String)key, (CoreEvent)this.event);
    }

    @Override
    public void doPut(String key, Object value) {
        this.eventBuider.addVariable(key, value);
        this.event = this.eventBuider.build();
    }

    @Override
    public void doRemove(String key) {
        this.eventBuider.removeVariable(key);
        this.event = this.eventBuider.build();
    }

    @Override
    public Set<String> keySet() {
        return this.event.getVariables().keySet();
    }

    @Override
    public void clear() {
        this.eventBuider.variables(Collections.emptyMap());
        this.event = this.eventBuider.build();
    }

    public String toString() {
        HashMap map = new HashMap();
        this.event.getVariables().forEach((key, value) -> {
            Object object = value != null ? value.getValue() : null;
            map.put(key, object);
        });
        return ((Object)map).toString();
    }
}

