/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.ValueResolvingException;
import org.mule.runtime.module.extension.internal.runtime.config.ResolverSetBasedParameterResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class OperationParameterValueResolver<T extends ComponentModel>
implements ParameterValueResolver {
    private final T operationModel;
    private final ResolverSet resolverSet;
    private final ExpressionManager expressionManager;
    private final ExecutionContext<T> executionContext;
    private final Map<String, String> showInDslParameters;
    private final ReflectionCache reflectionCache;

    OperationParameterValueResolver(ExecutionContext<T> executionContext, ResolverSet resolverSet, ReflectionCache reflectionCache, ExpressionManager expressionManager) {
        this.executionContext = executionContext;
        this.operationModel = executionContext.getComponentModel();
        this.resolverSet = resolverSet;
        this.expressionManager = expressionManager;
        this.showInDslParameters = IntrospectionUtils.getShowInDslParameters(this.operationModel);
        this.reflectionCache = reflectionCache;
    }

    @Override
    public Object getParameterValue(String parameterName) throws ValueResolvingException {
        try {
            return this.getParameterGroup(parameterName).map(pair -> {
                if (!((ParameterGroupModel)pair.getSecond()).isShowInDsl()) {
                    return new ParameterGroupArgumentResolver((ParameterGroupDescriptor)pair.getFirst(), this.reflectionCache, this.expressionManager).resolve(this.executionContext);
                }
                String parameterGroupContainerName = IntrospectionUtils.getContainerName(((ParameterGroupDescriptor)pair.getFirst()).getContainer());
                if (parameterGroupContainerName != null && this.executionContext.hasParameter(parameterGroupContainerName)) {
                    return this.executionContext.getParameter(parameterGroupContainerName);
                }
                return null;
            }).orElseGet(() -> {
                String showInDslGroupName = this.showInDslParameters.get(parameterName);
                if (showInDslGroupName != null) {
                    if (this.resolverSet.getResolvers().get(showInDslGroupName).isDynamic()) {
                        try {
                            return new ResolverSetBasedParameterResolver(this.resolverSet, (ParameterizedModel)this.operationModel, this.reflectionCache, this.expressionManager).getParameterValue(parameterName);
                        }
                        catch (ValueResolvingException e) {
                            return null;
                        }
                    }
                    return this.getShowInDslParameterValue(parameterName, showInDslGroupName);
                }
                if (this.executionContext.hasParameter(parameterName)) {
                    return this.executionContext.getParameter(parameterName);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new ValueResolvingException("Unable to resolve value for the parameter: " + parameterName, e);
        }
    }

    private Optional<Pair<ParameterGroupDescriptor, ParameterGroupModel>> getParameterGroup(String parameterGroupName) {
        return this.operationModel.getParameterGroupModels().stream().filter(parameterGroupModel -> parameterGroupModel.getName().equals(parameterGroupName)).findFirst().map(parameterGroupModel -> {
            Optional parameterGroupModelModelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class);
            if (!parameterGroupModelModelProperty.isPresent()) {
                return null;
            }
            return new Pair((Object)((ParameterGroupModelProperty)parameterGroupModelModelProperty.get()).getDescriptor(), parameterGroupModel);
        });
    }

    private Object getShowInDslParameterValue(String parameterName, String showInDslGroupName) {
        Object group = this.executionContext.getParameter(showInDslGroupName);
        try {
            return IntrospectionUtils.getFieldValue(group, parameterName, this.reflectionCache);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalStateException(String.format("An error occurred trying to obtain the field '%s' from the group '%s' of the Operation '%s'", parameterName, showInDslGroupName, this.operationModel.getName()));
        }
    }

    @Override
    public Map<String, ValueResolver<? extends Object>> getParameters() {
        return Collections.unmodifiableMap(this.resolverSet.getResolvers());
    }
}

