/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.internal.memory.management;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.memory.provider.ByteBufferPoolConfiguration;
import org.mule.runtime.api.memory.provider.ByteBufferProvider;
import org.mule.runtime.api.memory.provider.type.ByteBufferType;

public class ArtifactMemoryManagementService
implements MemoryManagementService {
    private final MemoryManagementService containerMemoryManagementService;
    private final Map<String, ByteBufferProvider<?>> byteBufferProviders = new ConcurrentHashMap();

    public ArtifactMemoryManagementService(MemoryManagementService containerMemoryManagementService) {
        this.containerMemoryManagementService = containerMemoryManagementService;
    }

    public ByteBufferProvider<?> getByteBufferProvider(String name, ByteBufferType byteBufferType, ByteBufferPoolConfiguration byteBufferPoolConfiguration) {
        ByteBufferProvider byteBufferProvider = this.containerMemoryManagementService.getByteBufferProvider(name, byteBufferType, byteBufferPoolConfiguration);
        this.byteBufferProviders.put(name, byteBufferProvider);
        return byteBufferProvider;
    }

    public ByteBufferProvider<?> getByteBufferProvider(String name, ByteBufferType byteBufferType) {
        ByteBufferProvider byteBufferProvider = this.containerMemoryManagementService.getByteBufferProvider(name, byteBufferType);
        this.byteBufferProviders.put(name, byteBufferProvider);
        return byteBufferProvider;
    }

    public void disposeByteBufferProvider(String name) {
        this.containerMemoryManagementService.disposeByteBufferProvider(name);
        this.byteBufferProviders.remove(name);
    }

    public void dispose() {
        this.byteBufferProviders.keySet().forEach(this::disposeByteBufferProvider);
    }

    public void initialise() throws InitialisationException {
    }
}

