/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.io.File;
import org.mule.runtime.core.api.util.FileUtils;

public class FilenameUtils {
    public static File fileWithPathComponents(String[] pathComponents) {
        if (pathComponents == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(64);
        for (int i = 0; i < pathComponents.length; ++i) {
            String component = pathComponents[i];
            if (component == null) continue;
            buf.append(component);
            if (i >= pathComponents.length - 1) continue;
            buf.append(File.separator);
        }
        return FileUtils.newFile(buf.toString());
    }

    public static String normalizeDecodedPath(String resource, boolean isWindows) {
        if (resource == null) {
            return null;
        }
        if (!resource.startsWith("file:/")) {
            return resource;
        }
        resource = resource.substring(6);
        if (isWindows ? resource.startsWith("/") : !resource.startsWith(File.separator)) {
            return File.separator + resource;
        }
        return resource;
    }

    private FilenameUtils() {
    }
}

