/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.MutableDoublePointData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.state.Measurement;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DoubleLastValueAggregator
implements Aggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleLastValueAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier) {
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoublePointData diff(DoublePointData previous, DoublePointData current) {
        return current;
    }

    @Override
    public void diffInPlace(DoublePointData previousReusable, DoublePointData current) {
        ((MutableDoublePointData)previousReusable).set(current);
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public void toPoint(Measurement measurement, DoublePointData reusablePoint) {
        ((MutableDoublePointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);

        private Handle(ExemplarReservoir<DoubleExemplarData> reservoir) {
            super(reservoir);
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            Double value = reset ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

