/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.checksum;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.checksums.ProvidedChecksumsSource;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;

@Singleton
@Named(value="trusted2provided")
public final class TrustedToProvidedChecksumsSourceAdapter
implements ProvidedChecksumsSource {
    public static final String NAME = "trusted2provided";
    private final Map<String, TrustedChecksumsSource> trustedChecksumsSources;

    @Inject
    public TrustedToProvidedChecksumsSourceAdapter(Map<String, TrustedChecksumsSource> trustedChecksumsSources) {
        this.trustedChecksumsSources = Objects.requireNonNull(trustedChecksumsSources);
    }

    public Map<String, String> getProvidedArtifactChecksums(RepositorySystemSession session, ArtifactDownload transfer, RemoteRepository repository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        Map trustedChecksums;
        Artifact artifact = transfer.getArtifact();
        for (TrustedChecksumsSource trustedChecksumsSource : this.trustedChecksumsSources.values()) {
            trustedChecksums = trustedChecksumsSource.getTrustedArtifactChecksums(session, artifact, (ArtifactRepository)repository, checksumAlgorithmFactories);
            if (trustedChecksums == null || trustedChecksums.isEmpty()) continue;
            return trustedChecksums;
        }
        if (!transfer.getRepositories().isEmpty()) {
            for (RemoteRepository remoteRepository : transfer.getRepositories()) {
                for (TrustedChecksumsSource trustedChecksumsSource : this.trustedChecksumsSources.values()) {
                    trustedChecksums = trustedChecksumsSource.getTrustedArtifactChecksums(session, artifact, (ArtifactRepository)remoteRepository, checksumAlgorithmFactories);
                    if (trustedChecksums == null || trustedChecksums.isEmpty()) continue;
                    return trustedChecksums;
                }
            }
        }
        return null;
    }
}

