/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import java.util.List;

public abstract class ValueRenderer {
    protected final boolean named;
    protected final String ifEmpty;
    private final Escaper escaper;

    protected ValueRenderer(ExpressionType type) {
        this.named = type.isNamed();
        this.ifEmpty = type.getIfEmpty();
        String escaped = type.isRawExpand() ? "-._~:/?#[]@!$&'()*+,;=" : "-._~";
        this.escaper = new PercentEscaper(escaped, false);
    }

    public abstract List<String> render(VariableSpec var1, VariableValue var2) throws URITemplateException;

    protected final String pctEncode(String s) {
        return this.escaper.escape(s);
    }
}

