/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.util;

import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.property.InfrastructureParameterModelProperty;

public final class ExtensionValidationUtils {
    public static void validateNoInlineParameters(ParameterizedModel model, String kind, ProblemsReporter problemsReporter, DslSyntaxResolver dsl) {
        model.getParameterGroupModels().stream().forEach(group -> {
            if (group.isShowInDsl()) {
                problemsReporter.addError(new Problem((NamedObject)model, String.format("Invalid parameter group [%s] found in operation [%s], inline groups are not allowed in %s", group.getName(), model.getName(), kind)));
            }
            group.getParameterModels().stream().filter(parameter -> !parameter.getModelProperty(InfrastructureParameterModelProperty.class).isPresent()).forEach(parameter -> {
                if (dsl.resolve((ParameterModel)parameter).supportsChildDeclaration()) {
                    problemsReporter.addError(new Problem((NamedObject)model, String.format("Invalid parameter [%s] found in group [%s] of operation [%s], parameters that allow inline declaration are not allowed in %s. Use attribute declaration only for all the parameters.", parameter.getName(), group.getName(), model.getName(), kind)));
                }
            });
        });
    }

    private ExtensionValidationUtils() {
    }
}

