/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.MavenPomModel;

public class MuleSystemPluginMavenReactorResolver
implements MavenReactorResolver,
AutoCloseable {
    private static final String POM = "pom";
    private final File temporaryFolder;
    private final MavenPomModel effectiveModel;
    private final File pomFile;
    private final File artifactFile;

    public MuleSystemPluginMavenReactorResolver(File artifactFile, MavenClient mavenClient) {
        try {
            this.temporaryFolder = Files.createTempDirectory("tmpDirPrefix" + Math.random(), new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.effectiveModel = mavenClient.getEffectiveModel(artifactFile, Optional.of(this.temporaryFolder));
        this.pomFile = (File)this.effectiveModel.getPomFile().get();
        this.artifactFile = artifactFile;
    }

    public File findArtifact(BundleDescriptor bundleDescriptor) {
        if (this.checkArtifact(bundleDescriptor)) {
            if (bundleDescriptor.getType().equals(POM)) {
                return this.pomFile;
            }
            return this.artifactFile;
        }
        return null;
    }

    public List<String> findVersions(BundleDescriptor bundleDescriptor) {
        if (this.checkArtifact(bundleDescriptor)) {
            return Collections.singletonList(this.effectiveModel.getVersion());
        }
        return Collections.emptyList();
    }

    private boolean checkArtifact(BundleDescriptor bundleDescriptor) {
        return this.effectiveModel.getGroupId().equals(bundleDescriptor.getGroupId()) && this.effectiveModel.getArtifactId().equals(bundleDescriptor.getArtifactId()) && this.effectiveModel.getVersion().equals(bundleDescriptor.getVersion());
    }

    @Override
    public void close() {
        FileUtils.deleteQuietly((File)this.temporaryFolder);
    }
}

