/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.nio.DefaultSelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.slf4j.Logger;

class SelectionKeyHandlerInitializer {
    private static final String PROP = "org.glassfish.grizzly.DEFAULT_SELECTION_KEY_HANDLER";
    private static final Logger LOGGER = Grizzly.logger(SelectionKeyHandlerInitializer.class);

    SelectionKeyHandlerInitializer() {
    }

    static SelectionKeyHandler initHandler() {
        String className = System.getProperty(PROP);
        if (className != null) {
            try {
                Class<?> handlerClass = Class.forName(className, true, SelectionKeyHandler.class.getClassLoader());
                return (SelectionKeyHandler)handlerClass.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Unable to load or create a new instance of SelectionKeyHandler {}.  Cause: {}", (Object)className, (Object)e.getMessage());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(e.toString(), (Throwable)e);
                }
                return new DefaultSelectionKeyHandler();
            }
        }
        return new DefaultSelectionKeyHandler();
    }
}

