/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.LazyResolvingFeatureManager;
import org.togglz.core.util.NamedFeature;
import org.togglz.core.util.Validate;

public class FeatureMap
implements Map<Object, Boolean> {
    private final FeatureManager manager;

    public FeatureMap() {
        this(new LazyResolvingFeatureManager());
    }

    public FeatureMap(FeatureManager manager) {
        this.manager = manager;
    }

    @Override
    public Boolean get(Object key) {
        Validate.notNull(key, "The feature must not be null");
        Feature feature = null;
        feature = key instanceof Feature ? (Feature)key : new NamedFeature(key.toString());
        return this.manager.isActive(feature);
    }

    @Override
    public int size() {
        return this.manager.getFeatures().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean put(Object key, Boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Boolean> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Object> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Boolean> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Object, Boolean>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

