/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.LoadingState;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONArray;
import org.json.JSONObject;

class CombinedSchemaLoader {
    private static final Map<String, CombinedSchemaProvider> COMB_SCHEMA_PROVIDERS = new HashMap<String, CombinedSchemaProvider>(3);
    private final LoadingState ls;
    private final SchemaLoader defaultLoader;

    public CombinedSchemaLoader(LoadingState ls, SchemaLoader defaultLoader) {
        this.ls = Objects.requireNonNull(ls, "ls cannot be null");
        this.defaultLoader = Objects.requireNonNull(defaultLoader, "defaultLoader cannot be null");
    }

    public Optional<Schema.Builder<?>> load() {
        List presentKeys = COMB_SCHEMA_PROVIDERS.keySet().stream().filter(arg_0 -> ((JSONObject)this.ls.schemaJson).has(arg_0)).collect(Collectors.toList());
        if (presentKeys.size() > 1) {
            throw new SchemaException(String.format("expected at most 1 of 'allOf', 'anyOf', 'oneOf', %d found", presentKeys.size()));
        }
        if (presentKeys.size() == 1) {
            String key = (String)presentKeys.get(0);
            JSONArray subschemaDefs = this.ls.schemaJson.getJSONArray(key);
            Collection subschemas = IntStream.range(0, subschemaDefs.length()).mapToObj(arg_0 -> ((JSONArray)subschemaDefs).getJSONObject(arg_0)).map(this.defaultLoader::loadChild).map(Schema.Builder::build).collect(Collectors.toList());
            CombinedSchema.Builder combinedSchema = (CombinedSchema.Builder)COMB_SCHEMA_PROVIDERS.get(key).apply(subschemas);
            Schema.Builder<?> baseSchema = this.ls.schemaJson.has("type") ? this.defaultLoader.loadForType(this.ls.schemaJson.get("type")) : this.defaultLoader.sniffSchemaByProps();
            if (baseSchema == null) {
                return Optional.of(combinedSchema);
            }
            return Optional.of(CombinedSchema.allOf(Arrays.asList(baseSchema.build(), combinedSchema.build())));
        }
        return Optional.empty();
    }

    static {
        COMB_SCHEMA_PROVIDERS.put("allOf", CombinedSchema::allOf);
        COMB_SCHEMA_PROVIDERS.put("anyOf", CombinedSchema::anyOf);
        COMB_SCHEMA_PROVIDERS.put("oneOf", CombinedSchema::oneOf);
    }

    @FunctionalInterface
    private static interface CombinedSchemaProvider
    extends Function<Collection<Schema>, CombinedSchema.Builder> {
    }
}

