/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.troubleshooting.internal.operations;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.module.troubleshooting.api.ArgumentDefinition;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperation;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationCallback;
import org.mule.runtime.module.troubleshooting.api.TroubleshootingOperationDefinition;
import org.mule.runtime.module.troubleshooting.internal.DefaultTroubleshootingOperationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicInfoOperation
implements TroubleshootingOperation {
    public static final String BASIC_INFO_OPERATION_NAME = "basicInfo";
    public static final String BASIC_INFO_OPERATION_DESCRIPTION = "Collects basic environment and metadata information for the current Mule Runtime";
    private static final TroubleshootingOperationDefinition definition = BasicInfoOperation.createOperationDefinition();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BasicInfoOperation.class.getName());
    private static final Set<String> SENSITIVE_PROPERTIES = new HashSet<String>(Arrays.asList("anypoint.platform.client_secret", "anypoint.platform.proxy_username", "anypoint.platform.proxy_password", "anypoint.platform.encryption_key", "mule.session.sign.cloudHub.secretKey"));

    @Override
    public TroubleshootingOperationDefinition getDefinition() {
        return definition;
    }

    @Override
    public TroubleshootingOperationCallback getCallback() {
        return (arguments, writer) -> {
            writer.write("Mule:" + System.lineSeparator());
            writer.write(String.format("  %s %s (build %s)", MuleManifest.getProductName(), MuleManifest.getProductVersion(), MuleManifest.getBuildNumber()) + System.lineSeparator());
            writer.write(String.format("  mule_home: %s", MuleFoldersUtil.getMuleHomeFolder().getAbsolutePath()) + System.lineSeparator());
            writer.write(String.format("  mule_base: %s", MuleFoldersUtil.getMuleBaseFolder().getAbsolutePath()) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("System Properties:" + System.lineSeparator());
            Map allProperties = System.getProperties().stringPropertyNames().stream().filter(property -> property.startsWith("mule.") || property.startsWith("com.mulesoft.dw") || property.startsWith("anypoint.platform")).filter(property -> !SENSITIVE_PROPERTIES.contains(property)).collect(Collectors.toMap(UnaryOperator.identity(), System::getProperty, (v1, v2) -> v1, TreeMap::new));
            for (Map.Entry entry : allProperties.entrySet()) {
                writer.write(String.format("  %s: %s", entry.getKey(), entry.getValue()) + System.lineSeparator());
            }
            writer.write(System.lineSeparator());
            writer.write("Java:" + System.lineSeparator());
            writer.write(String.format("  Version:   %s", System.getProperty("java.version")) + System.lineSeparator());
            writer.write(String.format("  Vendor:    %s", System.getProperty("java.vendor")) + System.lineSeparator());
            writer.write(String.format("  VM name:   %s", System.getProperty("java.vm.name")) + System.lineSeparator());
            writer.write(String.format("  JAVA_HOME: %s", System.getProperty("java.home")) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("OS:" + System.lineSeparator());
            writer.write(String.format("  Name:      %s", System.getProperty("os.name")) + System.lineSeparator());
            writer.write(String.format("  Version:   %s", System.getProperty("os.version")) + System.lineSeparator());
            writer.write(String.format("  Arch:      %s", System.getProperty("os.arch")) + System.lineSeparator());
            writer.write(System.lineSeparator());
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            writer.write(String.format("Running time: %s", DurationFormatUtils.formatDuration((long)runtimeMxBean.getUptime(), (String)"d'd' HH:mm:ss.SSS")));
            writer.write(System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("Process Information:" + System.lineSeparator());
            writer.write(String.format("  PID: %d", Long.parseLong(runtimeMxBean.getName().split("@")[0])) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("Report Generation:" + System.lineSeparator());
            writer.write(String.format("  Report Millis Time: %d", System.currentTimeMillis()) + System.lineSeparator());
            writer.write(String.format("  Report Nano Time: %d", System.nanoTime()) + System.lineSeparator());
            writer.write(System.lineSeparator());
            writer.write("System Resources:" + System.lineSeparator());
            Runtime runtime = Runtime.getRuntime();
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            long usedMemory = totalMemory - freeMemory;
            long maxMemory = runtime.maxMemory();
            writer.write(String.format("  memory.used=%s", BasicInfoOperation.formatBytes(usedMemory)) + System.lineSeparator());
            writer.write(String.format("  memory.free=%s", BasicInfoOperation.formatBytes(freeMemory)) + System.lineSeparator());
            writer.write(String.format("  memory.total=%s", BasicInfoOperation.formatBytes(totalMemory)) + System.lineSeparator());
            writer.write(String.format("  memory.max=%s", BasicInfoOperation.formatBytes(maxMemory)) + System.lineSeparator());
            writer.write(String.format("  memory.used/total=%.2f%%", (double)usedMemory / (double)totalMemory * 100.0) + System.lineSeparator());
            writer.write(String.format("  memory.used/max=%.2f%%", (double)usedMemory / (double)maxMemory * 100.0) + System.lineSeparator());
            writer.write(String.format("  load.process=%.2f%%", BasicInfoOperation.getProcessCpuLoad()) + System.lineSeparator());
            writer.write(String.format("  load.system=%.2f%%", BasicInfoOperation.getSystemCpuLoad()) + System.lineSeparator());
            writer.write(String.format("  load.systemAverage=%.2f%%", BasicInfoOperation.getSystemLoadAverage()) + System.lineSeparator());
        };
    }

    private static TroubleshootingOperationDefinition createOperationDefinition() {
        return new DefaultTroubleshootingOperationDefinition(BASIC_INFO_OPERATION_NAME, BASIC_INFO_OPERATION_DESCRIPTION, new ArgumentDefinition[0]);
    }

    private static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        String pre = "KMGTPE".charAt(exp - 1) + "";
        return String.format("%.1f%s", (double)bytes / Math.pow(1024.0, exp), pre);
    }

    private static double getProcessCpuLoad() {
        try {
            java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            if (osBean instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
                return sunOsBean.getProcessCpuLoad() * 100.0;
            }
            LOGGER.info("Process CPU load not available");
        }
        catch (Exception e) {
            LOGGER.info("Failed to get process CPU load", (Throwable)e);
        }
        return -1.0;
    }

    private static double getSystemCpuLoad() {
        try {
            java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            if (osBean instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean sunOsBean = (OperatingSystemMXBean)osBean;
                return sunOsBean.getSystemCpuLoad() * 100.0;
            }
            LOGGER.info("System CPU load not available");
        }
        catch (Exception e) {
            LOGGER.info("Failed to get system CPU load", (Throwable)e);
        }
        return -1.0;
    }

    private static double getSystemLoadAverage() {
        try {
            java.lang.management.OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            double loadAverage = osBean.getSystemLoadAverage();
            if (loadAverage >= 0.0) {
                return loadAverage * 100.0;
            }
            LOGGER.info("System load average not available");
        }
        catch (Exception e) {
            LOGGER.info("Failed to get system load average", (Throwable)e);
        }
        return -1.0;
    }
}

