/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jgrapht.Graph;
import org.jgrapht.generate.GraphGenerator;

public class GridGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String CORNER_VERTEX = "Corner Vertex";
    private final int rows;
    private final int cols;

    public GridGraphGenerator(int rows, int cols) {
        if (rows < 2) {
            throw new IllegalArgumentException("illegal number of rows (" + rows + "). there must be at least two.");
        }
        if (cols < 2) {
            throw new IllegalArgumentException("illegal number of columns (" + cols + "). there must be at least two.");
        }
        this.rows = rows;
        this.cols = cols;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, V> resultMap) {
        TreeMap<Integer, V> map = new TreeMap<Integer, V>();
        int cornerCtr = 0;
        for (int i = 0; i < this.rows * this.cols; ++i) {
            boolean isCorner;
            V vertex = target.addVertex();
            map.put(i + 1, vertex);
            boolean bl = isCorner = i == 0 || i == this.cols - 1 || i == this.cols * (this.rows - 1) || i == this.rows * this.cols - 1;
            if (!isCorner || resultMap == null) continue;
            resultMap.put("Corner Vertex " + ++cornerCtr, vertex);
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Iterator iterator2 = map.keySet().iterator();
            while (iterator2.hasNext()) {
                int j = (Integer)iterator2.next();
                if ((i % this.cols <= 0 || i + 1 != j) && i + this.cols != j) continue;
                target.addEdge(map.get(i), map.get(j));
                target.addEdge(map.get(j), map.get(i));
            }
        }
    }
}

