/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderFilterFactory;
import org.mule.runtime.container.internal.DefaultMuleContainerClassLoaderWrapper;
import org.mule.runtime.container.internal.DefaultPreFilteredContainerClassLoaderCreator;
import org.mule.runtime.container.internal.FilteringContainerClassLoader;
import org.mule.runtime.container.internal.PreFilteredContainerClassLoaderCreator;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ExportedService;
import org.mule.runtime.module.artifact.api.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class ContainerClassLoaderFactory {
    private final PreFilteredContainerClassLoaderCreator preFilteredContainerClassLoaderCreator;
    private final Function<ClassLoader, ClassLoader> parentClassLoaderResolver;

    public ContainerClassLoaderFactory(PreFilteredContainerClassLoaderCreator preFilteredContainerClassLoaderCreator, Function<ClassLoader, ClassLoader> parentClassLoaderResolver) {
        Objects.requireNonNull(preFilteredContainerClassLoaderCreator, "containerClassLoaderCreator cannot be null");
        this.preFilteredContainerClassLoaderCreator = preFilteredContainerClassLoaderCreator;
        this.parentClassLoaderResolver = parentClassLoaderResolver;
    }

    public ContainerClassLoaderFactory(ModuleRepository moduleRepository) {
        this(new DefaultPreFilteredContainerClassLoaderCreator(moduleRepository), classLoader -> MuleSystemProperties.classloaderContainerJpmsModuleLayer() ? ClassLoader.getSystemClassLoader() : classLoader);
    }

    public ContainerClassLoaderFactory(ModuleRepository moduleRepository, Set<String> bootPackages, Set<String> additionalExportedResourceDirectories) {
        this(new DefaultPreFilteredContainerClassLoaderCreator(moduleRepository, bootPackages, additionalExportedResourceDirectories), classLoader -> MuleSystemProperties.classloaderContainerJpmsModuleLayer() ? ClassLoader.getSystemClassLoader() : classLoader);
    }

    public MuleContainerClassLoaderWrapper createContainerClassLoader(ClassLoader parentClassLoader) {
        List<MuleContainerModule> muleModules = this.preFilteredContainerClassLoaderCreator.getMuleModules();
        return new DefaultMuleContainerClassLoaderWrapper(this.createArtifactClassLoader(parentClassLoader, muleModules, new ArtifactDescriptor("mule")));
    }

    protected ArtifactClassLoader createArtifactClassLoader(ClassLoader parentClassLoader, List<MuleContainerModule> muleModules, ArtifactDescriptor artifactDescriptor) {
        return this.createContainerFilteringClassLoader(this.parentClassLoaderResolver.apply(parentClassLoader), muleModules, this.preFilteredContainerClassLoaderCreator.getPreFilteredContainerClassLoader(artifactDescriptor, parentClassLoader));
    }

    protected FilteringArtifactClassLoader createContainerFilteringClassLoader(ClassLoader parentClassLoader, List<MuleContainerModule> muleModules, ArtifactClassLoader containerClassLoader) {
        return new FilteringContainerClassLoader(parentClassLoader, containerClassLoader, new ContainerClassLoaderFilterFactory().create(this.preFilteredContainerClassLoaderCreator.getBootPackages(), muleModules, this.preFilteredContainerClassLoaderCreator.getAdditionalExportedResourceDirectories()), this.getExportedServices(muleModules));
    }

    private List<ExportedService> getExportedServices(List<MuleContainerModule> muleModules) {
        ArrayList<ExportedService> exportedServices = new ArrayList<ExportedService>();
        for (MuleContainerModule muleModule : muleModules) {
            if (!(muleModule instanceof MuleModule)) continue;
            exportedServices.addAll(((MuleModule)muleModule).getExportedServices());
        }
        return exportedServices;
    }
}

