/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorMappingValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class SourceErrorMappingAnyNotRepeated
extends AbstractErrorMappingValidation {
    public String getName() {
        return "Source error-mapping ANY not repeated";
    }

    public String getDescription() {
        return "Mapping for 'ANY' or empty is not repeated.";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    protected Optional<ValidationResultItem> validateErrorMapping(ComponentAst component, ComponentParameterAst errorMappingsParam, List<ErrorMapping> mappings) {
        if (mappings.stream().filter(this::isErrorMappingWithSourceAny).count() > 1L) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (ComponentParameterAst)errorMappingsParam, (Validation)this, (String)"Only one mapping for 'ANY' or an empty source type is allowed."));
        }
        return Optional.empty();
    }
}

