/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.context.notification.MuleContextListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.lifecycle.StartException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.internal.exception.GlobalErrorHandler;
import org.mule.runtime.core.internal.interception.InterceptorManager;
import org.mule.runtime.core.internal.interception.ReactiveInterceptor;
import org.mule.runtime.core.internal.processor.chain.InterceptedReactiveProcessor;
import org.mule.runtime.core.internal.processor.interceptor.ProcessorInterceptorFactoryAdapter;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptorAdapter;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.profiling.context.DefaultComponentThreadingProfilingEventContext;
import org.mule.runtime.core.internal.profiling.tracing.event.span.condition.NotNullSpanAssertion;
import org.mule.runtime.core.internal.rx.FluxSinkRecorder;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.internal.util.rx.RxUtils;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.EventProcessingException;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.ChainErrorHandlingUtils;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.UnnamedComponent;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.runtime.tracer.api.component.ComponentTracerFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import reactor.core.CoreSubscriber;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

abstract class AbstractMessageProcessorChain
extends AbstractExecutableComponent
implements MessageProcessorChain {
    private static final String TCCL_REACTOR_CTX_KEY = "mule.context.tccl";
    private static final String TCCL_ORIGINAL_REACTOR_CTX_KEY = "mule.context.tccl_original";
    private static final String REACTOR_ON_OPERATOR_ERROR_LOCAL = "reactor.onOperatorError.local";
    private static final String UNEXPECTED_ERROR_HANDLER_STATE_MESSAGE = "Unexpected state. Error handler should be invoked with either an Event instance or a MessagingException. This may lead to an event getting stuck, or even a processor may stop responding.";
    public static final String UNKNOWN = "unknown";
    private static Class<ClassLoader> appClClass;
    private static final Logger LOGGER;
    private static final Consumer<Context> TCCL_REACTOR_CTX_CONSUMER;
    private static final Consumer<Context> TCCL_ORIGINAL_REACTOR_CTX_CONSUMER;
    private final String name;
    private final List<Processor> processors;
    private final FlowExceptionHandler messagingExceptionHandler;
    private final ProcessingStrategy processingStrategy;
    private final List<ReactiveInterceptorAdapter> additionalInterceptors = new LinkedList<ReactiveInterceptorAdapter>();
    private boolean canProcessMessage = true;
    @Inject
    private ServerNotificationHandler serverNotificationHandler;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private InterceptorManager processorInterceptorManager;
    @Inject
    private StreamingManager streamingManager;
    @Inject
    private InternalProfilingService profilingService;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ComponentTracerFactory<CoreEvent> componentTracerFactory;
    private ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> startingOperationExecutionDataProducer;
    private ProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> endOperationExecutionDataProducer;
    private Scheduler switchOnErrorScheduler;
    private EventTracer<CoreEvent> muleEventTracer;
    private ComponentTracer<CoreEvent> chainComponentTracer;
    private MuleContextListener stopListener;
    private boolean chainSpanCreated = false;
    private static final Component UNKNOWN_COMPONENT;

    AbstractMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, FlowExceptionHandler messagingExceptionHandler) {
        this.name = name;
        this.processingStrategy = processingStrategyOptional.orElse(null);
        this.processors = processors;
        this.messagingExceptionHandler = messagingExceptionHandler;
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        List<ReactiveInterceptor> interceptors = this.resolveInterceptors();
        if (this.messagingExceptionHandler != null) {
            FluxSinkRecorder errorSwitchSinkSinkRef = new FluxSinkRecorder();
            return Flux.deferContextual(ctx -> {
                AtomicInteger inflightEvents = new AtomicInteger();
                Consumer<Exception> errorRouter = this.getRouter(() -> this.messagingExceptionHandler.router(pub -> Flux.from((Publisher)pub).contextWrite(ctx), handled -> {
                    if (this.chainSpanCreated) {
                        this.chainComponentTracer.endCurrentSpan((Event)handled);
                    }
                    errorSwitchSinkSinkRef.next(Either.right((Object)handled));
                }, rethrown -> {
                    CoreEvent coreEvent = ((EventProcessingException)((Object)((Object)((Object)((Object)rethrown))))).getEvent();
                    if (this.chainSpanCreated) {
                        this.muleEventTracer.recordErrorAtCurrentSpan((Event)coreEvent, () -> ChainErrorHandlingUtils.resolveError((EventProcessingException)((Object)((Object)((Object)((Object)((Object)rethrown))))), this.errorTypeLocator), true);
                        this.chainComponentTracer.endCurrentSpan((Event)coreEvent);
                    }
                    errorSwitchSinkSinkRef.next(Either.left((Object)((Object)((MessagingException)((Object)((Object)((Object)((Object)rethrown)))))), CoreEvent.class));
                }), this.recreateRouter((ContextView)ctx));
                Flux upstream = Flux.from(this.doApply(publisher, interceptors, (context, throwable) -> {
                    inflightEvents.incrementAndGet();
                    if (this.chainSpanCreated) {
                        this.muleEventTracer.recordErrorAtCurrentSpan((Event)((MessagingException)((Object)((Object)((Object)throwable)))).getEvent(), () -> ChainErrorHandlingUtils.resolveError((MessagingException)((Object)((Object)((Object)((Object)throwable)))), this.errorTypeLocator), true);
                        this.muleEventTracer.endCurrentSpan((Event)((MessagingException)((Object)((Object)((Object)throwable)))).getEvent(), NotNullSpanAssertion.getNotNullSpanTracingCondition());
                    }
                    this.routeError(errorRouter, (Exception)throwable);
                }));
                return Flux.from(RxUtils.propagateCompletion(upstream, errorSwitchSinkSinkRef.flux(), pub -> Flux.from((Publisher)pub).map(event -> {
                    Either result = Either.right(MessagingException.class, (Object)event);
                    errorSwitchSinkSinkRef.next(result);
                    return result;
                }), inflightEvents, () -> {
                    errorSwitchSinkSinkRef.complete();
                    LifecycleUtils.disposeIfNeeded(errorRouter, LOGGER);
                    this.clearRouterInGlobalErrorHandler(this.messagingExceptionHandler);
                }, t -> {
                    errorSwitchSinkSinkRef.error((Throwable)t);
                    LifecycleUtils.disposeIfNeeded(errorRouter, LOGGER);
                    this.clearRouterInGlobalErrorHandler(this.messagingExceptionHandler);
                })).map(RxUtils.propagateErrorResponseMapper());
            });
        }
        return this.doApply(publisher, interceptors, (context, throwable) -> {
            CoreEvent coreEvent = ((MessagingException)((Object)((Object)throwable))).getEvent();
            this.muleEventTracer.recordErrorAtCurrentSpan((Event)coreEvent, true);
            this.muleEventTracer.endCurrentSpan((Event)coreEvent, NotNullSpanAssertion.getNotNullSpanTracingCondition());
            this.muleEventTracer.recordErrorAtCurrentSpan((Event)coreEvent, true);
            this.chainComponentTracer.endCurrentSpan((Event)coreEvent);
            context.error((Throwable)throwable);
        });
    }

    private boolean recreateRouter(ContextView ctx) {
        return (Boolean)ctx.getOrDefault((Object)"recreateRouter", (Object)false) != false || TransactionCoordination.isTransactionActive();
    }

    private Consumer<Exception> getRouter(Supplier<Consumer<Exception>> errorRouterSupplier, boolean recreateRouter) {
        Consumer<Exception> errorRouter = this.messagingExceptionHandler instanceof GlobalErrorHandler && !recreateRouter ? ((GlobalErrorHandler)this.messagingExceptionHandler).routerForChain(this, errorRouterSupplier) : errorRouterSupplier.get();
        return errorRouter;
    }

    private void clearRouterInGlobalErrorHandler(FlowExceptionHandler messagingExceptionHandler) {
        if (messagingExceptionHandler instanceof GlobalErrorHandler) {
            ((GlobalErrorHandler)messagingExceptionHandler).clearRouterForChain(this);
        }
    }

    private void routeError(Consumer<Exception> errorRouter, Exception throwable) {
        if (!TransactionCoordination.isTransactionActive() && !this.schedulerService.isCurrentThreadInWaitGroup()) {
            Map mdc = MDC.getCopyOfContextMap();
            this.switchOnErrorScheduler.submit(() -> {
                try {
                    MDC.setContextMap((Map)mdc);
                    errorRouter.accept(throwable);
                }
                finally {
                    MDC.clear();
                }
            });
        } else {
            errorRouter.accept(throwable);
        }
    }

    @Deprecated
    public Publisher<CoreEvent> doApply(Publisher<CoreEvent> publisher, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        return this.doApply(publisher, this.resolveInterceptors(), errorBubbler);
    }

    private Publisher<CoreEvent> doApply(Publisher<CoreEvent> publisher, List<ReactiveInterceptor> interceptors, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        Flux stream = Flux.from(publisher);
        stream = stream.doOnNext(event -> this.chainComponentTracer.startSpan((Event)event).ifPresent(span -> {
            this.chainSpanCreated = true;
        }));
        for (Processor processor : this.getProcessorsToExecute()) {
            stream = stream.transform((Function)this.applyInterceptors(interceptors, processor)).subscriberContext(context -> context.put((Object)REACTOR_ON_OPERATOR_ERROR_LOCAL, ChainErrorHandlingUtils.getLocalOperatorErrorHook(processor, this.errorTypeLocator, this.exceptionContextProviders))).onErrorContinue(exception -> !(exception instanceof LifecycleException), this.getContinueStrategyErrorHandler(processor, errorBubbler));
        }
        stream = stream.doOnNext(event -> this.chainComponentTracer.endCurrentSpan((Event)event));
        stream = stream.subscriberContext(ctx -> {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            if (tccl == null || tccl.getParent() == null || appClClass == null || !appClClass.isAssignableFrom(tccl.getClass())) {
                return ctx;
            }
            return ctx.put((Object)TCCL_ORIGINAL_REACTOR_CTX_KEY, (Object)tccl).put((Object)TCCL_REACTOR_CTX_KEY, (Object)tccl.getParent());
        });
        return stream;
    }

    private BiConsumer<Throwable, Object> getContinueStrategyErrorHandler(Processor processor, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        MessagingExceptionResolver exceptionResolver = processor instanceof Component ? new MessagingExceptionResolver((Component)processor) : null;
        Function<MessagingException, MessagingException> messagingExceptionMapper = ChainErrorHandlingUtils.resolveMessagingException(processor, e -> exceptionResolver.resolve((MessagingException)((Object)e), this.errorTypeLocator, this.exceptionContextProviders));
        return (throwable, object) -> {
            throwable = org.mule.runtime.core.api.rx.Exceptions.unwrap(throwable);
            if (!(object instanceof CoreEvent) && !(throwable instanceof MessagingException)) {
                LOGGER.error(UNEXPECTED_ERROR_HANDLER_STATE_MESSAGE, throwable);
                throwable = new MessagingException(NullEventFactory.getNullEvent(), (Throwable)throwable);
            }
            if (object != null && !(object instanceof CoreEvent)) {
                this.notifyError(processor, (BaseEventContext)((MessagingException)((Object)((Object)throwable))).getEvent().getContext(), (MessagingException)((Object)((Object)messagingExceptionMapper.apply((MessagingException)((Object)((Object)throwable))))), errorBubbler);
            } else {
                CoreEvent event = (CoreEvent)object;
                if (throwable instanceof MessagingException) {
                    this.notifyError(processor, (BaseEventContext)(event != null ? event.getContext() : ((MessagingException)((Object)((Object)throwable))).getEvent().getContext()), (MessagingException)((Object)((Object)messagingExceptionMapper.apply((MessagingException)((Object)((Object)throwable))))), errorBubbler);
                } else {
                    this.notifyError(processor, (BaseEventContext)event.getContext(), ChainErrorHandlingUtils.resolveException(processor, event, throwable, this.errorTypeLocator, this.exceptionContextProviders, exceptionResolver), errorBubbler);
                }
            }
        };
    }

    private void notifyError(Processor processor, BaseEventContext context, MessagingException resolvedException, BiConsumer<BaseEventContext, ? super Exception> errorBubbler) {
        this.errorNotification(processor).andThen((? super T t) -> errorBubbler.accept(context, (Exception)t)).accept((Exception)((Object)resolvedException));
    }

    private ReactiveProcessor applyInterceptors(List<ReactiveInterceptor> interceptorsToBeExecuted, Processor processor) {
        ReactiveProcessor interceptorWrapperProcessorFunction = processor;
        for (ReactiveInterceptor interceptor : interceptorsToBeExecuted) {
            interceptorWrapperProcessorFunction = (ReactiveProcessor)interceptor.apply(processor, interceptorWrapperProcessorFunction);
        }
        return interceptorWrapperProcessorFunction;
    }

    private List<ReactiveInterceptor> resolveInterceptors() {
        ArrayList<ReactiveInterceptor> interceptors = new ArrayList<ReactiveInterceptor>();
        interceptors.add((processor, next) -> stream -> Flux.from((Publisher)stream).doOnNext(event -> this.beforeProcessorInSameThread((CoreEvent)event, (Processor)processor)).transform(this.doOnNextOrErrorWithContext(TCCL_REACTOR_CTX_CONSUMER).andThen(next).andThen(this.doOnNextOrErrorWithContext(TCCL_ORIGINAL_REACTOR_CTX_CONSUMER))).doOnNext(event -> this.afterProcessorInSameThread((CoreEvent)event, (Processor)processor)));
        if (this.processingStrategy != null) {
            interceptors.add((processor, next) -> this.processingStrategy.onProcessor(new InterceptedReactiveProcessor((ReactiveProcessor)processor, (ReactiveProcessor)next)));
        }
        interceptors.addAll(this.additionalInterceptors);
        interceptors.add((processor, next) -> {
            String processorPath = AbstractMessageProcessorChain.getProcessorPath((Processor)processor);
            ComponentTracer<CoreEvent> coreComponentTracer = this.getComponentTracer((ReactiveProcessor)processor, this.chainComponentTracer);
            return stream -> Flux.from((Publisher)stream).doOnNext(event -> this.beforeComponentProcessingStrategy((Processor)processor, processorPath, (CoreEvent)event, coreComponentTracer)).transform((Function)next).map(result -> this.afterComponentProcessingStrategy((Processor)processor, processorPath, (CoreEvent)result));
        });
        return interceptors;
    }

    private void beforeProcessorInSameThread(CoreEvent event, Processor processor) {
        DefaultMuleContext.currentMuleContext.set(this.muleContext);
        PrivilegedEvent.setCurrentEvent((PrivilegedEvent)event);
    }

    private void afterProcessorInSameThread(CoreEvent event, Processor processor) {
        this.triggerOperationExecuted(event, AbstractMessageProcessorChain.getLocationIfComponent(processor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreEvent afterComponentProcessingStrategy(Processor processor, String processorPath, CoreEvent result) {
        try {
            this.postNotification(processor).accept(result);
            PrivilegedEvent.setCurrentEvent((PrivilegedEvent)result);
            this.muleEventTracer.endCurrentSpan((Event)result);
            CoreEvent coreEvent = StreamingUtils.updateEventForStreaming(this.streamingManager).apply(result);
            return coreEvent;
        }
        finally {
            if (processorPath != null) {
                MDC.remove((String)"processorPath");
            }
        }
    }

    private ComponentTracer<CoreEvent> getComponentTracer(ReactiveProcessor processor, ComponentTracer<CoreEvent> parentComponentTracer) {
        if (processor instanceof Component) {
            return this.componentTracerFactory.fromComponent((Component)processor, parentComponentTracer);
        }
        return this.componentTracerFactory.fromComponent(UNKNOWN_COMPONENT, UNKNOWN, "");
    }

    private void beforeComponentProcessingStrategy(Processor processor, String processorPath, CoreEvent event, ComponentTracer<CoreEvent> componentTracer) {
        componentTracer.startSpan((Event)event);
        if (!this.canProcessMessage) {
            throw Exceptions.propagate((Throwable)((Object)new MessagingException(event, new LifecycleException(CoreMessages.isStopped(this.name), (Object)event.getMessage()))));
        }
        if (processorPath != null) {
            MDC.put((String)"processorPath", (String)processorPath);
        }
        ComponentLocation componentLocation = AbstractMessageProcessorChain.getLocationIfComponent(processor);
        this.triggerStartingOperation(event, componentLocation);
        this.preNotification(event, processor);
    }

    private void triggerOperationExecuted(CoreEvent event, ComponentLocation componentLocation) {
        if (this.startingOperationExecutionDataProducer == null) {
            return;
        }
        this.endOperationExecutionDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultComponentThreadingProfilingEventContext(event, componentLocation, Thread.currentThread().getName(), ProfilingUtils.getArtifactId(this.muleContext), ProfilingUtils.getArtifactType(this.muleContext), System.currentTimeMillis()));
    }

    private void triggerStartingOperation(CoreEvent event, ComponentLocation componentLocation) {
        if (this.startingOperationExecutionDataProducer == null) {
            return;
        }
        this.startingOperationExecutionDataProducer.triggerProfilingEvent((ProfilingEventContext)new DefaultComponentThreadingProfilingEventContext(event, componentLocation, Thread.currentThread().getName(), ProfilingUtils.getArtifactId(this.muleContext), ProfilingUtils.getArtifactType(this.muleContext), System.currentTimeMillis()));
    }

    private static ComponentLocation getLocationIfComponent(Processor processor) {
        if (processor instanceof Component && ((Component)processor).getLocation() != null) {
            return ((Component)processor).getLocation();
        }
        return null;
    }

    private static String getProcessorPath(Processor processor) {
        if (processor instanceof Component && ((Component)processor).getLocation() != null) {
            return ((Component)processor).getLocation().getLocation();
        }
        return null;
    }

    private void registerStopListener() {
        if (this.muleContext instanceof DefaultMuleContext) {
            this.stopListener = new MuleContextListener(){

                @Override
                public void onCreation(MuleContext context) {
                }

                @Override
                public void onInitialization(MuleContext context, Registry registry) {
                }

                @Override
                public void onStart(MuleContext context, Registry registry) {
                }

                @Override
                public void onStop(MuleContext context, Registry registry) {
                    AbstractMessageProcessorChain.this.canProcessMessage = false;
                    ((DefaultMuleContext)AbstractMessageProcessorChain.this.muleContext).removeListener(this);
                }
            };
            ((DefaultMuleContext)this.muleContext).addListener(this.stopListener);
        }
    }

    private Function<? super Publisher<CoreEvent>, ? extends Publisher<CoreEvent>> doOnNextOrErrorWithContext(final Consumer<Context> contextConsumer) {
        return Operators.lift((scannable, subscriber) -> new CoreSubscriber<CoreEvent>(){

            public void onNext(CoreEvent event) {
                contextConsumer.accept(this.currentContext());
                subscriber.onNext((Object)event);
            }

            public void onError(Throwable throwable) {
                contextConsumer.accept(this.currentContext());
                subscriber.onError(throwable);
            }

            public void onComplete() {
                subscriber.onComplete();
            }

            public Context currentContext() {
                return subscriber.currentContext();
            }

            public void onSubscribe(Subscription s) {
                subscriber.onSubscribe(s);
            }
        });
    }

    private void preNotification(CoreEvent event, Processor processor) {
        if (((PrivilegedEvent)event).isNotificationsEnabled()) {
            this.fireNotification(event, processor, null, 1601);
        }
    }

    private Consumer<CoreEvent> postNotification(Processor processor) {
        return event -> {
            if (((PrivilegedEvent)event).isNotificationsEnabled()) {
                this.fireNotification((CoreEvent)event, processor, null, 1602);
            }
        };
    }

    private Consumer<Exception> errorNotification(Processor processor) {
        return exception -> {
            if (exception instanceof MessagingException && ((PrivilegedEvent)((MessagingException)((Object)((Object)exception))).getEvent()).isNotificationsEnabled()) {
                this.fireNotification(((MessagingException)((Object)((Object)exception))).getEvent(), processor, (MessagingException)((Object)((Object)exception)), 1602);
            }
        };
    }

    private void fireNotification(CoreEvent event, Processor processor, MessagingException exceptionThrown, int action) {
        if (this.serverNotificationHandler != null && processor instanceof Component && ((Component)processor).getLocation() != null) {
            this.serverNotificationHandler.fireNotification((Notification)MessageProcessorNotification.createFrom((Event)event, (ComponentLocation)((Component)processor).getLocation(), (Component)((Component)processor), (Exception)((Object)exceptionThrown), (int)action));
        }
    }

    protected List<Processor> getProcessorsToExecute() {
        return this.processors;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName());
        if (!org.mule.runtime.core.api.util.StringUtils.isBlank(this.name)) {
            string.append(String.format(" '%s' ", this.name));
        }
        Iterator<Processor> mpIterator = this.processors.iterator();
        String nl = String.format("%n", new Object[0]);
        if (mpIterator.hasNext()) {
            string.append(String.format("%n[ ", new Object[0]));
            while (mpIterator.hasNext()) {
                Processor mp = mpIterator.next();
                String indented = StringUtils.replace((String)mp.toString(), (String)nl, (String)String.format("%n  ", new Object[0]));
                string.append(String.format("%n  %s", indented));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append(String.format("%n]", new Object[0]));
        }
        return string.toString();
    }

    @Override
    public List<Processor> getMessageProcessors() {
        return this.processors;
    }

    protected List<Processor> getMessageProcessorsForLifecycle() {
        return this.processors;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.getMessageProcessorsForLifecycle(), muleContext);
    }

    public void initialise() throws InitialisationException {
        this.additionalInterceptors.addAll(ReactiveInterceptorAdapter.createInterceptors(this.processorInterceptorManager.getInterceptorFactories().stream().map(ProcessorInterceptorFactoryAdapter::new).collect(Collectors.toList()), this.muleContext.getInjector()));
        LifecycleUtils.initialiseIfNeeded(this.getMessageProcessorsForLifecycle(), this.muleContext);
        this.startingOperationExecutionDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION);
        this.endOperationExecutionDataProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.OPERATION_EXECUTED);
        if (this.switchOnErrorScheduler == null) {
            this.switchOnErrorScheduler = this.schedulerService.cpuLightScheduler();
        }
        this.muleEventTracer = this.profilingService.getCoreEventTracer();
        if (this.chainComponentTracer == null) {
            this.chainComponentTracer = this.componentTracerFactory.fromComponent((Component)this);
        }
    }

    public void start() throws MuleException {
        ArrayList<Processor> startedProcessors = new ArrayList<Processor>();
        try {
            for (Processor processor : this.getMessageProcessorsForLifecycle()) {
                if (!(processor instanceof Startable)) continue;
                this.startProcessor((Startable)processor);
                startedProcessors.add(processor);
            }
        }
        catch (MuleException e) {
            LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
            throw e;
        }
        this.registerStopListener();
        this.canProcessMessage = true;
    }

    private void startProcessor(Startable startableProcessor) throws StartException {
        try {
            startableProcessor.start();
        }
        catch (Exception e) {
            throw new StartException(I18nMessageFactory.createStaticMessage((String)"%s starting %s...", (Object[])new Object[]{e.getClass(), startableProcessor.toString()}), e, startableProcessor);
        }
    }

    public void stop() throws MuleException {
        this.canProcessMessage = false;
        LifecycleUtils.stopIfNeeded(this.getMessageProcessorsForLifecycle());
        if (this.stopListener != null) {
            ((DefaultMuleContext)this.muleContext).removeListener(this.stopListener);
        }
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getMessageProcessorsForLifecycle(), LOGGER);
        if (this.switchOnErrorScheduler != null) {
            this.switchOnErrorScheduler.stop();
            this.switchOnErrorScheduler = null;
        }
    }

    FlowExceptionHandler getMessagingExceptionHandler() {
        return this.messagingExceptionHandler;
    }

    public void setComponentTracer(ComponentTracer<CoreEvent> chainComponentTracer) {
        this.chainComponentTracer = chainComponentTracer;
    }

    static {
        LOGGER = LoggerFactory.getLogger(AbstractMessageProcessorChain.class);
        TCCL_REACTOR_CTX_CONSUMER = context -> context.getOrEmpty((Object)TCCL_REACTOR_CTX_KEY).ifPresent(cl -> Thread.currentThread().setContextClassLoader((ClassLoader)cl));
        TCCL_ORIGINAL_REACTOR_CTX_CONSUMER = context -> context.getOrEmpty((Object)TCCL_ORIGINAL_REACTOR_CTX_KEY).ifPresent(cl -> Thread.currentThread().setContextClassLoader((ClassLoader)cl));
        try {
            appClClass = AbstractMessageProcessorChain.class.getClassLoader().loadClass("org.mule.runtime.deployment.model.api.application.ApplicationClassLoader");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("ApplicationClassLoader interface not available in current context", (Throwable)e);
        }
        UNKNOWN_COMPONENT = UnnamedComponent.getUnnamedComponent();
    }
}

