/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.api.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.collection.SmallMap;

public final class HttpEncoderDecoderUtils {
    private static final Pattern SPACES_MATCHER = Pattern.compile(" ");
    private static final String SPACE_ENTITY = "%20";

    private HttpEncoderDecoderUtils() {
    }

    public static String extractPath(String uri) {
        String path = uri;
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public static String extractQueryParams(String uri) {
        int i = uri.indexOf("?");
        String queryString = "";
        if (i > -1) {
            queryString = uri.substring(i + 1);
        }
        return queryString;
    }

    public static MultiMap<String, String> decodeQueryString(String queryString) {
        return HttpEncoderDecoderUtils.decodeUrlEncodedBody(queryString, StandardCharsets.UTF_8);
    }

    public static String encodeQueryString(Map<String, String> parameters) {
        return HttpEncoderDecoderUtils.encodeString(parameters, StandardCharsets.UTF_8);
    }

    public static MultiMap<String, String> decodeUrlEncodedBody(String queryString, Charset encoding) {
        if (queryString != null && queryString.trim().length() > 0) {
            String[] pairs;
            MultiMap.StringMultiMap queryParams = new MultiMap.StringMultiMap();
            for (String pair : pairs = queryString.split("&")) {
                int idx = pair.indexOf("=");
                if (idx != -1) {
                    HttpEncoderDecoderUtils.addParam((MultiMap<String, String>)queryParams, pair.substring(0, idx), pair.substring(idx + 1), encoding);
                    continue;
                }
                HttpEncoderDecoderUtils.addParam((MultiMap<String, String>)queryParams, pair, null, encoding);
            }
            return queryParams;
        }
        return MultiMap.emptyMultiMap();
    }

    public static Map<String, String> decodeUriParams(String pathWithUriParams, String requestPath) {
        if (pathWithUriParams.contains("{")) {
            SmallMap uriParams = new SmallMap();
            String[] requestPathParts = requestPath.split("/");
            String[] listenerPathParts = pathWithUriParams.split("/");
            int longerPathSize = Math.min(requestPathParts.length, listenerPathParts.length);
            for (int i = 1; i < longerPathSize; ++i) {
                String listenerPart = listenerPathParts[i];
                if (!listenerPart.startsWith("{") || !listenerPart.endsWith("}")) continue;
                String parameterName = listenerPart.substring(1, listenerPart.length() - 1);
                String parameterValue = requestPathParts[i];
                uriParams.put(parameterName, HttpEncoderDecoderUtils.decode(parameterValue, StandardCharsets.UTF_8));
            }
            return uriParams;
        }
        return Collections.emptyMap();
    }

    private static void addParam(MultiMap<String, String> queryParams, String name, String value, Charset encoding) {
        queryParams.put((Object)HttpEncoderDecoderUtils.decode(name, encoding), (Object)HttpEncoderDecoderUtils.decode(value, encoding));
    }

    private static String decode(String text, Charset encoding) {
        if (text == null) {
            return null;
        }
        try {
            return URLDecoder.decode(text, encoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public static String encodeString(Map parameters, Charset encoding) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : parameters.entrySet()) {
            String paramName = entry.getKey().toString();
            Object paramValue = entry.getValue();
            List<Object> paramValues = paramValue instanceof Iterable ? (List<Object>)paramValue : Arrays.asList(paramValue);
            for (Object t : paramValues) {
                try {
                    paramName = URLEncoder.encode(paramName, encoding.name());
                    paramValue = t != null ? URLEncoder.encode(t.toString(), encoding.name()) : null;
                }
                catch (UnsupportedEncodingException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
                if (result.length() > 0) {
                    result.append("&");
                }
                result.append(paramName);
                if (paramValue == null) continue;
                result.append("=");
                result.append(paramValue);
            }
        }
        String body = result.toString();
        return body;
    }

    public static String encodeSpaces(String path) {
        return SPACES_MATCHER.matcher(path).replaceAll(SPACE_ENTITY);
    }

    public static String appendQueryParam(String url, String queryParamName, String queryParamValue) {
        try {
            return (url.contains("?") ? url + "&" : url + "?") + URLEncoder.encode(queryParamName, StandardCharsets.UTF_8.name()) + "=" + URLEncoder.encode(queryParamValue, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

