/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.concurrent.Delayed;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.service.scheduler.internal.AbstractDelegatedScheduledFuture;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class QuartzScheduledFuture<V>
extends AbstractDelegatedScheduledFuture<V> {
    private final Scheduler quartzScheduler;
    private final Trigger trigger;

    QuartzScheduledFuture(Scheduler quartzScheduler, Trigger trigger, RunnableFuture<?> task) {
        super(task);
        this.quartzScheduler = quartzScheduler;
        this.trigger = trigger;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert((long)this.trigger.getNextFireTime().toInstant().getNano() - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long diff = this.getDelay(TimeUnit.NANOSECONDS) - o.getDelay(TimeUnit.NANOSECONDS);
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean quartzCancelled;
        try {
            quartzCancelled = this.quartzScheduler.unscheduleJob(this.trigger.getKey());
        }
        catch (SchedulerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        boolean taskCancelled = this.task.cancel(mayInterruptIfRunning);
        return quartzCancelled || taskCancelled;
    }

    @Override
    public boolean isDone() {
        return this.task.isCancelled() || this.task.isDone();
    }
}

