/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.core.internal.expression.util.ExpressionUtils;

public class OperationParameterDefaultValueDoesntSupportExpressions
implements Validation {
    private static final ComponentIdentifier OPTIONAL_PARAMETER_IDENTIFIER = ComponentIdentifier.builder().namespace("operation").name("optional-parameter").build();

    public String getName() {
        return "No expressions in optional parameter default value";
    }

    public String getDescription() {
        return "Expressions are forbidden for optional parameter default values";
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getIdentifier().equals(OPTIONAL_PARAMETER_IDENTIFIER));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst defaultValueAst = component.getParameter("General", "defaultValue");
        Optional defaultValue = defaultValueAst.getValue().getValue();
        if (ExpressionUtils.isExpression(defaultValue.orElse(null))) {
            return this.validationFailed(component, OperationParameterDefaultValueDoesntSupportExpressions.getParameterName(component));
        }
        return OperationParameterDefaultValueDoesntSupportExpressions.validationOk();
    }

    private static String getParameterName(ComponentAst component) {
        return (String)component.getParameter("General", "name").getValue().getValue().orElseThrow(() -> new IllegalStateException(String.format("Parameter in location '%s' doesn't have name", component.getLocation())));
    }

    private Optional<ValidationResultItem> validationFailed(ComponentAst component, String name) {
        return Optional.of(ValidationResultItem.create((ComponentAst)component, (Validation)this, (String)String.format("An expression was given for 'defaultValue' of the optional parameter '%s'", name)));
    }

    private static Optional<ValidationResultItem> validationOk() {
        return Optional.empty();
    }
}

