/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.tracer.api.context.SpanContextAware;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public abstract class AbstractEventContext
implements SpanContextAware,
BaseEventContext {
    private static final byte STATE_READY = 0;
    private static final byte STATE_RESPONSE = 1;
    private static final byte STATE_COMPLETE = 2;
    private static final byte STATE_TERMINATED = 3;
    private static final int TO_STRING_TAB_SIZE = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventContext.class);
    private static final FlowExceptionHandler NULL_EXCEPTION_HANDLER = NullExceptionHandler.getInstance();
    private final boolean debugLogEnabled = LOGGER.isDebugEnabled();
    private final transient List<BaseEventContext> childContexts = new ArrayList<BaseEventContext>();
    private final transient FlowExceptionHandler exceptionHandler;
    private final transient CompletableFuture<Void> externalCompletion;
    private transient List<BiConsumer<CoreEvent, Throwable>> onBeforeResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private transient List<BiConsumer<CoreEvent, Throwable>> onResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private transient List<BiConsumer<CoreEvent, Throwable>> onCompletionConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>(2);
    private transient List<BiConsumer<CoreEvent, Throwable>> onTerminatedConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
    private final ReadWriteLock childContextsReadWriteLock = new ReentrantReadWriteLock();
    private final int depthLevel;
    private volatile byte state = 0;
    private transient AtomicInteger childIdProvider = new AtomicInteger();
    private volatile Either<Throwable, CoreEvent> result;
    private LazyValue<ResponsePublisher> responsePublisher = new LazyValue(() -> new ResponsePublisher());
    protected FlowCallStack flowCallStack;

    public AbstractEventContext() {
        this(NULL_EXCEPTION_HANDLER, 0, Optional.empty());
    }

    public AbstractEventContext(FlowExceptionHandler exceptionHandler, int depthLevel, Optional<CompletableFuture<Void>> externalCompletion) {
        this.depthLevel = depthLevel;
        this.externalCompletion = externalCompletion.orElse(null);
        externalCompletion.ifPresent(completableFuture -> completableFuture.thenAccept(aVoid -> this.tryTerminate()));
        this.exceptionHandler = exceptionHandler;
    }

    protected void initCompletionLists() {
        if (this.onBeforeResponseConsumerList == null) {
            this.onBeforeResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
        }
        if (this.onResponseConsumerList == null) {
            this.onResponseConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
        }
        if (this.onCompletionConsumerList == null) {
            this.onCompletionConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>(2);
        }
        if (this.onTerminatedConsumerList == null) {
            this.onTerminatedConsumerList = new ArrayList<BiConsumer<CoreEvent, Throwable>>();
        }
    }

    void addChildContext(BaseEventContext childContext) {
        this.childContextsReadWriteLock.writeLock().lock();
        try {
            this.childContexts.add(childContext);
        }
        finally {
            this.childContextsReadWriteLock.writeLock().unlock();
        }
    }

    @Override
    public final void success() {
        if (this.isResponseDone()) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} empty response was already completed, ignoring.", (Object)this);
            }
            return;
        }
        if (this.debugLogEnabled) {
            LOGGER.debug("{} response completed with no result.", (Object)this);
        }
        this.responseDone((Either<Throwable, CoreEvent>)Either.right(null));
    }

    @Override
    public final void success(CoreEvent event) {
        if (this.isResponseDone()) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} response was already completed, ignoring.", (Object)this);
            }
            return;
        }
        if (this.debugLogEnabled) {
            LOGGER.debug("{} response completed with result.", (Object)this);
        }
        this.responseDone((Either<Throwable, CoreEvent>)Either.right((Object)event));
    }

    @Override
    public final Publisher<Void> error(Throwable throwable) {
        if (this.isResponseDone()) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} error response was already completed, ignoring.", (Object)this);
            }
            return Mono.empty();
        }
        if (this.debugLogEnabled) {
            LOGGER.debug("{} responseDone completed with error.", (Object)this);
        }
        if (throwable instanceof MessagingException) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} handling messaging exception.", (Object)this);
            }
            Consumer<Exception> router = this.exceptionHandler.router((Function<Publisher<CoreEvent>, Publisher<CoreEvent>>)Functions.identity(), this::success, rethrown -> this.responseDone((Either<Throwable, CoreEvent>)Either.left((Object)rethrown)));
            try {
                router.accept((Exception)throwable);
            }
            finally {
                LifecycleUtils.disposeIfNeeded(router, LOGGER);
            }
        } else {
            this.responseDone((Either<Throwable, CoreEvent>)Either.left((Object)throwable));
        }
        return Mono.empty();
    }

    private synchronized void responseDone(Either<Throwable, CoreEvent> result) {
        this.result = result;
        this.responsePublisher.ifComputed(rp -> ((ResponsePublisher)rp).result = result);
        this.state = 1;
        for (BiConsumer<CoreEvent, Throwable> onBeforeResponseConsumer : this.onBeforeResponseConsumerList) {
            this.signalConsumerSilently(onBeforeResponseConsumer);
        }
        this.onBeforeResponseConsumerList.clear();
        for (BiConsumer<CoreEvent, Throwable> onResponseConsumer : this.onResponseConsumerList) {
            this.signalConsumerSilently(onResponseConsumer);
        }
        this.onResponseConsumerList.clear();
        this.tryComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryComplete() {
        boolean allChildrenComplete;
        this.getChildContextsReadLock().lock();
        try {
            allChildrenComplete = this.childContexts.stream().allMatch(BaseEventContext::isComplete);
        }
        finally {
            this.getChildContextsReadLock().unlock();
        }
        AbstractEventContext abstractEventContext = this;
        synchronized (abstractEventContext) {
            if (this.state == 1 && allChildrenComplete) {
                if (this.debugLogEnabled) {
                    LOGGER.debug("{} completed.", (Object)this);
                }
                this.state = (byte)2;
                for (BiConsumer<CoreEvent, Throwable> consumer : this.onCompletionConsumerList) {
                    this.signalConsumerSilently(consumer);
                }
                this.onCompletionConsumerList.clear();
                this.getParentContext().ifPresent(context -> {
                    if (context instanceof AbstractEventContext) {
                        ((AbstractEventContext)context).tryComplete();
                    }
                });
                this.tryTerminate();
            }
        }
    }

    protected synchronized void tryTerminate() {
        if (this.state == 2 && (this.externalCompletion == null || this.externalCompletion.isDone())) {
            if (this.debugLogEnabled) {
                LOGGER.debug("{} terminated.", (Object)this);
            }
            this.state = (byte)3;
            for (BiConsumer<CoreEvent, Throwable> consumer : this.onTerminatedConsumerList) {
                this.signalConsumerSilently(consumer);
            }
            this.onTerminatedConsumerList.clear();
            this.getChildContextsWriteLock().lock();
            try {
                this.childContexts.clear();
            }
            finally {
                this.getChildContextsWriteLock().unlock();
            }
            this.getParentContext().ifPresent(context -> {
                AbstractEventContext parent = (AbstractEventContext)context;
                parent.getChildContextsWriteLock().lock();
                try {
                    parent.childContexts.remove(this);
                }
                finally {
                    parent.getChildContextsWriteLock().unlock();
                }
            });
            this.result = null;
            this.responsePublisher = null;
        }
    }

    private void signalConsumerSilently(BiConsumer<CoreEvent, Throwable> consumer) {
        try {
            consumer.accept((CoreEvent)this.result.getRight(), (Throwable)this.result.getLeft());
        }
        catch (Throwable t) {
            LOGGER.error(String.format("The event consumer %s, of EventContext %s failed with exception:", consumer, this), t);
        }
    }

    @Override
    public BaseEventContext getRootContext() {
        return this.getParentContext().map(BaseEventContext::getRootContext).orElse(this);
    }

    protected FlowExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public boolean isResponseDone() {
        return this.state >= 1;
    }

    @Override
    public boolean isComplete() {
        return this.state >= 2;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 3;
    }

    @Override
    public synchronized void onTerminated(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 3) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onTerminatedConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized void onComplete(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 2) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onCompletionConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized void onBeforeResponse(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 1) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onBeforeResponseConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized void onResponse(BiConsumer<CoreEvent, Throwable> consumer) {
        if (this.state >= 1) {
            this.signalConsumerSilently(consumer);
        } else {
            this.onResponseConsumerList.add(Objects.requireNonNull(consumer));
        }
    }

    @Override
    public synchronized Publisher<CoreEvent> getResponsePublisher() {
        if (this.isTerminated()) {
            throw new IllegalStateException("getResponsePublisher() cannot be called after eventContext termination.");
        }
        return Mono.create((Consumer)((Consumer)this.responsePublisher.get()));
    }

    public void forEachChild(Consumer<BaseEventContext> childConsumer) {
        this.getChildContextsReadLock().lock();
        try {
            this.childContexts.stream().filter(context -> !context.isTerminated()).forEach(context -> {
                childConsumer.accept((BaseEventContext)context);
                if (context instanceof AbstractEventContext) {
                    ((AbstractEventContext)context).forEachChild(childConsumer);
                }
            });
        }
        finally {
            this.getChildContextsReadLock().unlock();
        }
    }

    @Override
    public int getDepthLevel() {
        return this.depthLevel;
    }

    public Lock getChildContextsReadLock() {
        return this.childContextsReadWriteLock.readLock();
    }

    public Lock getChildContextsWriteLock() {
        return this.childContextsReadWriteLock.writeLock();
    }

    protected abstract String basicToString();

    protected final String detailedToString(int level, BaseEventContext highlight) {
        return (this == highlight ? "=> " : "") + this.basicToString() + System.lineSeparator() + this.childContexts.stream().map(ctx -> StringUtils.leftPad((String)"", (int)((1 + level) * 4)) + ((AbstractEventContext)ctx).detailedToString(1 + level, highlight)).collect(Collectors.joining(System.lineSeparator()));
    }

    protected byte getState() {
        return this.state;
    }

    @Override
    public String nextChildId() {
        return this.getId() != null ? this.getId() + "_" + this.childIdProvider.getAndIncrement() : "" + this.childIdProvider.getAndIncrement();
    }

    private final class ResponsePublisher
    implements Consumer<MonoSink<CoreEvent>> {
        private volatile Either<Throwable, CoreEvent> result;

        private ResponsePublisher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(MonoSink<CoreEvent> sink) {
            if (AbstractEventContext.this.isResponseDone()) {
                this.signalPublisherSink(sink);
            } else {
                AbstractEventContext abstractEventContext = AbstractEventContext.this;
                synchronized (abstractEventContext) {
                    if (AbstractEventContext.this.isResponseDone()) {
                        this.signalPublisherSink(sink);
                    } else {
                        AbstractEventContext.this.onResponse((event, throwable) -> {
                            if (throwable != null) {
                                sink.error(throwable);
                            } else {
                                sink.success(event);
                            }
                        });
                    }
                }
            }
        }

        private void signalPublisherSink(MonoSink<CoreEvent> sink) {
            if (this.result.isLeft()) {
                sink.error((Throwable)this.result.getLeft());
            } else {
                sink.success((Object)((CoreEvent)this.result.getRight()));
            }
        }
    }
}

