/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.jodah.failsafe.AbstractExecution;
import net.jodah.failsafe.DelayablePolicy;
import net.jodah.failsafe.ExecutionContext;
import net.jodah.failsafe.ExecutionResult;
import net.jodah.failsafe.PolicyExecutor;
import net.jodah.failsafe.function.CheckedRunnable;
import net.jodah.failsafe.internal.CircuitBreakerInternals;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.ClosedState;
import net.jodah.failsafe.internal.HalfOpenState;
import net.jodah.failsafe.internal.OpenState;
import net.jodah.failsafe.internal.executor.CircuitBreakerExecutor;
import net.jodah.failsafe.internal.util.Assert;
import net.jodah.failsafe.util.Ratio;

public class CircuitBreaker<R>
extends DelayablePolicy<CircuitBreaker<R>, R> {
    private final AtomicReference<CircuitState> state = new AtomicReference();
    private final AtomicInteger currentExecutions = new AtomicInteger();
    private Duration delay = Duration.ofMinutes(1L);
    private Duration timeout;
    private Ratio failureThreshold;
    private Ratio successThreshold;
    CheckedRunnable onOpen;
    CheckedRunnable onHalfOpen;
    CheckedRunnable onClose;
    final CircuitBreakerInternals internals = new CircuitBreakerInternals(){

        @Override
        public int getCurrentExecutions() {
            return CircuitBreaker.this.currentExecutions.get();
        }

        @Override
        public void recordFailure(ExecutionResult result, ExecutionContext context) {
            try {
                ((CircuitState)CircuitBreaker.this.state.get()).recordFailure(result, context);
            }
            finally {
                CircuitBreaker.this.currentExecutions.decrementAndGet();
            }
        }

        @Override
        public void open(ExecutionResult result, ExecutionContext context) {
            CircuitBreaker.this.transitionTo(State.OPEN, CircuitBreaker.this.onOpen, result, context);
        }
    };

    public CircuitBreaker() {
        this.failureConditions = new ArrayList();
        this.state.set(new ClosedState(this, this.internals));
    }

    public boolean allowsExecution() {
        return this.state.get().allowsExecution();
    }

    public void close() {
        this.transitionTo(State.CLOSED, this.onClose, null, null);
    }

    public Duration getDelay() {
        return this.delay;
    }

    public long getFailureCount() {
        return this.state.get().getFailureCount();
    }

    public Ratio getFailureRatio() {
        return this.state.get().getFailureRatio();
    }

    public int getSuccessCount() {
        return this.state.get().getSuccessCount();
    }

    public Ratio getSuccessRatio() {
        return this.state.get().getSuccessRatio();
    }

    public Ratio getFailureThreshold() {
        return this.failureThreshold;
    }

    public State getState() {
        return this.state.get().getInternals();
    }

    public Ratio getSuccessThreshold() {
        return this.successThreshold;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void halfOpen() {
        this.transitionTo(State.HALF_OPEN, this.onHalfOpen, null, null);
    }

    public boolean isClosed() {
        return State.CLOSED.equals((Object)this.getState());
    }

    public boolean isHalfOpen() {
        return State.HALF_OPEN.equals((Object)this.getState());
    }

    public boolean isOpen() {
        return State.OPEN.equals((Object)this.getState());
    }

    public CircuitBreaker<R> onClose(CheckedRunnable runnable) {
        this.onClose = runnable;
        return this;
    }

    public CircuitBreaker<R> onHalfOpen(CheckedRunnable runnable) {
        this.onHalfOpen = runnable;
        return this;
    }

    public CircuitBreaker<R> onOpen(CheckedRunnable runnable) {
        this.onOpen = runnable;
        return this;
    }

    public void open() {
        this.transitionTo(State.OPEN, this.onOpen, null, null);
    }

    public void preExecute() {
        this.currentExecutions.incrementAndGet();
    }

    public void recordFailure() {
        this.internals.recordFailure(null, null);
    }

    public void recordFailure(Throwable failure) {
        this.recordResult(null, failure);
    }

    public void recordResult(R result) {
        this.recordResult(result, null);
    }

    public void recordSuccess() {
        try {
            this.state.get().recordSuccess();
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    public String toString() {
        return this.getState().toString();
    }

    public CircuitBreaker<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        Assert.isTrue(delay.toNanos() >= 0L, "delay must not be negative", new Object[0]);
        this.delay = delay;
        return this;
    }

    public CircuitBreaker<R> withFailureThreshold(int failureThreshold) {
        Assert.isTrue(failureThreshold >= 1, "failureThreshold must be greater than or equal to 1", new Object[0]);
        return this.withFailureThreshold(failureThreshold, failureThreshold);
    }

    public synchronized CircuitBreaker<R> withFailureThreshold(int failures, int executions) {
        Assert.isTrue(failures >= 1, "failures must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= 1, "executions must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= failures, "executions must be greater than or equal to failures", new Object[0]);
        this.failureThreshold = new Ratio(failures, executions);
        this.state.get().setFailureThreshold(this.failureThreshold);
        return this;
    }

    public CircuitBreaker<R> withSuccessThreshold(int successThreshold) {
        Assert.isTrue(successThreshold >= 1, "successThreshold must be greater than or equal to 1", new Object[0]);
        return this.withSuccessThreshold(successThreshold, successThreshold);
    }

    public synchronized CircuitBreaker<R> withSuccessThreshold(int successes, int executions) {
        Assert.isTrue(successes >= 1, "successes must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= 1, "executions must be greater than or equal to 1", new Object[0]);
        Assert.isTrue(executions >= successes, "executions must be greater than or equal to successes", new Object[0]);
        this.successThreshold = new Ratio(successes, executions);
        this.state.get().setSuccessThreshold(this.successThreshold);
        return this;
    }

    public CircuitBreaker<R> withTimeout(Duration timeout) {
        Assert.notNull(timeout, "timeout");
        Assert.isTrue(timeout.toNanos() > 0L, "timeout must be greater than 0", new Object[0]);
        this.timeout = timeout;
        return this;
    }

    void recordResult(R result, Throwable failure) {
        try {
            if (this.isFailure(result, failure)) {
                this.state.get().recordFailure(null, null);
            } else {
                this.state.get().recordSuccess();
            }
        }
        finally {
            this.currentExecutions.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitionTo(State newState, CheckedRunnable listener, ExecutionResult result, ExecutionContext context) {
        boolean transitioned = false;
        CircuitBreaker circuitBreaker = this;
        synchronized (circuitBreaker) {
            if (!this.getState().equals((Object)newState)) {
                switch (newState) {
                    case CLOSED: {
                        this.state.set(new ClosedState(this, this.internals));
                        break;
                    }
                    case OPEN: {
                        Duration computedDelay = this.computeDelay(result, context);
                        this.state.set(new OpenState(this, this.state.get(), computedDelay != null ? computedDelay : this.delay));
                        break;
                    }
                    case HALF_OPEN: {
                        this.state.set(new HalfOpenState(this, this.internals));
                    }
                }
                transitioned = true;
            }
        }
        if (transitioned && listener != null) {
            try {
                listener.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new CircuitBreakerExecutor(this, this.internals, execution);
    }

    public static enum State {
        CLOSED,
        OPEN,
        HALF_OPEN;

    }
}

