/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.Objects;
import org.everit.json.schema.Schema;
import org.everit.json.schema.internal.JSONPrinter;

public class ReferenceSchema
extends Schema {
    private Schema referredSchema;
    private final String refValue;

    public static Builder builder() {
        return new Builder();
    }

    public ReferenceSchema(Builder builder) {
        super(builder);
        this.refValue = Objects.requireNonNull(builder.refValue, "refValue cannot be null");
    }

    @Override
    public void validate(Object subject) {
        if (this.referredSchema == null) {
            throw new IllegalStateException("referredSchema must be injected before validation");
        }
        this.referredSchema.validate(subject);
    }

    @Override
    public boolean definesProperty(String field) {
        if (this.referredSchema == null) {
            throw new IllegalStateException("referredSchema must be injected before validation");
        }
        return this.referredSchema.definesProperty(field);
    }

    public Schema getReferredSchema() {
        return this.referredSchema;
    }

    public void setReferredSchema(Schema referredSchema) {
        if (this.referredSchema != null) {
            throw new IllegalStateException("referredSchema can be injected only once");
        }
        this.referredSchema = referredSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ReferenceSchema) {
            ReferenceSchema that = (ReferenceSchema)o;
            return that.canEqual(this) && Objects.equals(this.refValue, that.refValue) && Objects.equals(this.referredSchema, that.referredSchema) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.referredSchema, this.refValue);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceSchema;
    }

    @Override
    void describePropertiesTo(JSONPrinter writer) {
        writer.key("$ref");
        writer.value(this.refValue);
    }

    public static class Builder
    extends Schema.Builder<ReferenceSchema> {
        private ReferenceSchema retval;
        private String refValue = "";

        @Override
        public ReferenceSchema build() {
            if (this.retval == null) {
                this.retval = new ReferenceSchema(this);
            }
            return this.retval;
        }

        public Builder refValue(String refValue) {
            this.refValue = refValue;
            return this;
        }
    }
}

