/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.extension;

import java.util.Collections;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.extension.CustomBuildingDefinitionProviderModelProperty;
import org.mule.runtime.extension.api.ExtensionConstants;
import org.mule.runtime.extension.api.extension.XmlSdkTypesValueProvider;
import org.mule.runtime.extension.api.property.NoWrapperModelProperty;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.dsl.xml.XmlDslConstants;
import org.mule.runtime.extension.internal.loader.xml.XmlExtensionLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;

public class XmlSdk1ExtensionModelDeclarer {
    private static final String XMLSDK1_STEREOTYPE_NAMESPACE = "XML_SDK_1";
    private static final StereotypeModel PARAMS_STEREOTYPE = StereotypeModelBuilder.newStereotype((String)"PARAMETERS", (String)"XML_SDK_1").build();
    private static final StereotypeModel PROPERTY_STEREOTYPE = StereotypeModelBuilder.newStereotype((String)"PROPERTY", (String)"XML_SDK_1").build();
    private static final StereotypeModel ERRORS_STEREOTYPE = StereotypeModelBuilder.newStereotype((String)"ERRORS", (String)"XML_SDK_1").build();
    private static final StereotypeModel OUTPUT_STEREOTYPE = StereotypeModelBuilder.newStereotype((String)"OUTPUT", (String)"XML_SDK_1").build();
    private static final StereotypeModel OUTPUT_ATTRIBUTES_STEREOTYPE = StereotypeModelBuilder.newStereotype((String)"OUTPUT-ATTRIBUTES", (String)"XML_SDK_1").build();
    private final ValueProviderModel typesValueProvider = this.createTypesValueProviderModel();

    public ExtensionDeclarer createExtensionModel() {
        BaseTypeBuilder typeBuilder = BaseTypeBuilder.create((MetadataFormat)JavaTypeLoader.JAVA);
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer().named("module").describedAs("Mule Runtime and Integration Platform: XML SDK v1").onVersion(MuleExtensionModelProvider.MULE_VERSION).fromVendor("MuleSoft, Inc.").withCategory(Category.SELECT).supportingJavaVersions(ExtensionConstants.ALL_SUPPORTED_JAVA_VERSIONS).withModelProperty((ModelProperty)new CustomBuildingDefinitionProviderModelProperty()).withXmlDsl(XmlDslModel.builder().setPrefix("module").setNamespace(XmlDslConstants.MODULE_DSL_NAMESPACE_URI).setSchemaVersion(MuleExtensionModelProvider.MULE_VERSION).setXsdFileName("mule-module.xsd").setSchemaLocation(XmlModelUtils.buildSchemaLocation((String)"module", (String)XmlDslConstants.MODULE_DSL_NAMESPACE_URI)).build());
        this.declareModuleConstruct(extensionDeclarer, typeBuilder);
        this.declarePropertyElement(extensionDeclarer, typeBuilder);
        this.declareOperation(typeBuilder, extensionDeclarer);
        this.declareConnectionConstruct(extensionDeclarer);
        return extensionDeclarer;
    }

    private void declareConnectionConstruct(ExtensionDeclarer extensionDeclarer) {
        ((ConstructDeclarer)extensionDeclarer.withConstruct("connection").describedAs("A connection defines a set of properties that will be tight to the connection provider mechanism rather than the configuration (default behaviour).")).allowingTopLevelDefinition().withOptionalComponent("properties").withAllowedStereotypes(new StereotypeModel[]{PROPERTY_STEREOTYPE}).withMinOccurs(0).withMaxOccurs(null).withModelProperty((ModelProperty)NoWrapperModelProperty.INSTANCE);
    }

    private void declareModuleConstruct(ExtensionDeclarer extensionDeclarer, BaseTypeBuilder typeBuilder) {
        ConstructDeclarer module = ((ConstructDeclarer)extensionDeclarer.withConstruct("module").describedAs("A module is defined by three types of elements: properties, global elements and operations.")).allowingTopLevelDefinition();
        ParameterGroupDeclarer params = module.onDefaultParameterGroup();
        params.withRequiredParameter("name").describedAs("Name of the module that identifies it.").ofType(MuleExtensionModelProvider.STRING_TYPE).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED).asComponentId();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("category").describedAs("Set of defined categories for a module.")).ofType((MetadataType)typeBuilder.stringType().enumOf(new String[]{"COMMUNITY", "SELECT", "PREMIUM", "CERTIFIED"}).build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"COMMUNITY");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("vendor").describedAs("Expected vendor of the module.")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo((Object)"MuleSoft");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("requiredEntitlement").describedAs("The required entitlement in the customer module license.")).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)false).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("allowsEvaluationLicense").describedAs("If the module can be run with an evaluation license.")).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE)).defaultingTo((Object)true).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("namespace").describedAs("Expected namespace of the module to look for when generating the schemas. If left empty it will default to http://www.mulesoft.org/schema/mule/[prefix], where [prefix] is the attribute prefix attribute value.")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)params.withOptionalParameter("prefix").describedAs("Expected prefix of the module to look for when generating the schemas. If left empty it will create a default one based on the extension's name, removing the words \"extension\", \"module\" or \"connector\" at the end if they are present and hyphenizing the resulting name.")).ofType(MuleExtensionModelProvider.STRING_TYPE)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
    }

    private void declareOperation(BaseTypeBuilder typeBuilder, ExtensionDeclarer extensionDeclarer) {
        ConstructDeclarer operationDeclaration = extensionDeclarer.withConstruct("operation").allowingTopLevelDefinition();
        ParameterGroupDeclarer operationDefaultParamGroup = operationDeclaration.onDefaultParameterGroup();
        operationDefaultParamGroup.withRequiredParameter("name").asComponentId().ofType(MuleExtensionModelProvider.STRING_TYPE).describedAs("Every operation must be named so that it can be called in a mule application.");
        this.addDisplayParams(operationDefaultParamGroup);
        ((OptionalParameterDeclarer)operationDefaultParamGroup.withOptionalParameter("visibility").defaultingTo((Object)XmlExtensionLoaderDelegate.OperationVisibility.PUBLIC.name()).ofType((MetadataType)typeBuilder.stringType().enumOf(new String[]{XmlExtensionLoaderDelegate.OperationVisibility.PRIVATE.name(), XmlExtensionLoaderDelegate.OperationVisibility.PUBLIC.name()}).build())).describedAs("Describes weather the operation can be accessible outside the module or not.");
        ParameterGroupDeclarer parameterDefaultParamGroup = operationDeclaration.withOptionalComponent("parameters").withStereotype(PARAMS_STEREOTYPE).withOptionalComponent("parameter").withMaxOccurs(null).onDefaultParameterGroup();
        parameterDefaultParamGroup.withRequiredParameter("name").ofType(MuleExtensionModelProvider.STRING_TYPE);
        this.configureTypeParameter(parameterDefaultParamGroup.withRequiredParameter("type"));
        parameterDefaultParamGroup.withOptionalParameter("defaultValue").ofType(MuleExtensionModelProvider.STRING_TYPE);
        parameterDefaultParamGroup.withOptionalParameter("use").defaultingTo((Object)"AUTO").ofType((MetadataType)typeBuilder.stringType().enumOf(new String[]{"REQUIRED", "OPTIONAL", "AUTO"}).build());
        parameterDefaultParamGroup.withOptionalParameter("role").defaultingTo((Object)"BEHAVIOUR").ofType((MetadataType)typeBuilder.stringType().enumOf(new String[]{"BEHAVIOUR", "CONTENT", "PRIMARY"}).build());
        parameterDefaultParamGroup.withOptionalParameter("password").defaultingTo((Object)false).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE);
        this.addDisplayParams(parameterDefaultParamGroup);
        parameterDefaultParamGroup.withOptionalParameter("order").ofType(MuleExtensionModelProvider.INTEGER_TYPE);
        parameterDefaultParamGroup.withOptionalParameter("tab").defaultingTo((Object)"General").ofType(MuleExtensionModelProvider.STRING_TYPE);
        this.configureTypeParameter(operationDeclaration.withOptionalComponent("output").describedAs("Defines the output of the operation if exists, void otherwise.").withStereotype(OUTPUT_STEREOTYPE).onDefaultParameterGroup().withRequiredParameter("type"));
        this.configureTypeParameter(operationDeclaration.withOptionalComponent("output-attributes").describedAs("Defines the attribute's output of the operation if exists, void otherwise.").withStereotype(OUTPUT_ATTRIBUTES_STEREOTYPE).onDefaultParameterGroup().withRequiredParameter("type"));
        operationDeclaration.withChain("body");
        operationDeclaration.withOptionalComponent("errors").withStereotype(ERRORS_STEREOTYPE).describedAs("Collection of errors that might be thrown by the current operation.").withOptionalComponent("error").withMaxOccurs(null).onDefaultParameterGroup().withRequiredParameter("type").ofType(MuleExtensionModelProvider.STRING_TYPE).describedAs("Defined error for the current operation.");
    }

    private ParameterDeclarer configureTypeParameter(ParameterDeclarer parameter) {
        return parameter.ofType(MuleExtensionModelProvider.STRING_TYPE).withValueProviderModel(this.typesValueProvider);
    }

    private ValueProviderModel createTypesValueProviderModel() {
        return new ValueProviderModel(Collections.emptyList(), false, false, true, Integer.valueOf(0), "XmlSdkTypesValueProvider", "XmlSdkTypesValueProvider", new ModelProperty[]{ValueProviderFactoryModelProperty.builder(XmlSdkTypesValueProvider.class).build()});
    }

    private void declarePropertyElement(ExtensionDeclarer extensionDeclarer, BaseTypeBuilder typeBuilder) {
        ConstructDeclarer propertyDeclaration = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("property").describedAs("A property element defines an input value for the operation in which it is define. Such property must be defined with a meaningful name, a type which defines the kind of content the property must have and optionally a default value that will be used if the invocation to the operation does not defines a value for the property. The property can be accessed within the body definition of the operation using an expression such as #[property.paramName]")).allowingTopLevelDefinition().withStereotype(PROPERTY_STEREOTYPE);
        ParameterGroupDeclarer propertyDeclarationDefaultParamGroup = propertyDeclaration.onDefaultParameterGroup();
        propertyDeclarationDefaultParamGroup.withRequiredParameter("name").asComponentId().ofType(MuleExtensionModelProvider.STRING_TYPE);
        this.configureTypeParameter(propertyDeclarationDefaultParamGroup.withRequiredParameter("type"));
        propertyDeclarationDefaultParamGroup.withOptionalParameter("defaultValue").ofType(MuleExtensionModelProvider.STRING_TYPE);
        propertyDeclarationDefaultParamGroup.withOptionalParameter("use").defaultingTo((Object)"AUTO").ofType((MetadataType)typeBuilder.stringType().enumOf(new String[]{"REQUIRED", "OPTIONAL", "AUTO"}).build());
        propertyDeclarationDefaultParamGroup.withOptionalParameter("password").defaultingTo((Object)false).ofType(MuleExtensionModelProvider.BOOLEAN_TYPE);
        this.addDisplayParams(propertyDeclarationDefaultParamGroup);
        propertyDeclarationDefaultParamGroup.withOptionalParameter("order").ofType(MuleExtensionModelProvider.INTEGER_TYPE);
        propertyDeclarationDefaultParamGroup.withOptionalParameter("tab").defaultingTo((Object)"General").ofType(MuleExtensionModelProvider.STRING_TYPE);
    }

    private void addDisplayParams(ParameterGroupDeclarer ownerParamGroup) {
        ((OptionalParameterDeclarer)ownerParamGroup.withOptionalParameter("displayName").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("Display name of the operation. It can be any string. When empty, it will default to an auto generated one from the name attribute.");
        ((OptionalParameterDeclarer)ownerParamGroup.withOptionalParameter("summary").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("A very brief overview about this operation.");
        ((OptionalParameterDeclarer)ownerParamGroup.withOptionalParameter("example").ofType(MuleExtensionModelProvider.STRING_TYPE)).describedAs("An example about the content of this operation.");
    }
}

