/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel;

import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.privileged.el.context.AbstractMapContext;
import org.mule.runtime.core.privileged.registry.RegistrationException;

public class MVELArtifactContext {
    private final MuleContext muleContext;

    public MVELArtifactContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getName() {
        return this.muleContext.getConfiguration().getId();
    }

    public String getWorkDir() {
        return this.muleContext.getConfiguration().getWorkingDirectory();
    }

    public String getEncoding() {
        return this.muleContext.getConfiguration().getDefaultEncoding();
    }

    public boolean isStandalone() {
        return this.muleContext.getConfiguration().isStandalone();
    }

    public Map<String, Object> getRegistry() {
        return new RegistryWrapperMap(((MuleContextWithRegistry)this.muleContext).getRegistry());
    }

    protected Map<String, Object> createRegistry(Registry registry) {
        return new RegistryWrapperMap(((MuleContextWithRegistry)this.muleContext).getRegistry());
    }

    protected static class RegistryWrapperMap
    extends AbstractMapContext<Object> {
        private final MuleRegistry registry;

        public RegistryWrapperMap(MuleRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Object doGet(String key) {
            return this.registry.get(key);
        }

        @Override
        public void doPut(String key, Object value) {
            try {
                this.registry.registerObject(key, value);
            }
            catch (RegistrationException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        @Override
        public void doRemove(String key) {
            Object value = this.registry.lookupObject(key);
            if (value != null) {
                try {
                    this.registry.unregisterObject(key);
                }
                catch (RegistrationException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }
}

