/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.el.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.keyvalue.DefaultMapEntry;
import org.mule.api.annotation.NoExtend;

@NoExtend
public abstract class AbstractMapContext<V>
implements Map<String, V> {
    @Override
    public V get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        V value = null;
        try {
            value = this.doGet((String)key);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return value;
    }

    protected abstract V doGet(String var1);

    @Override
    public V remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        V previousValue = this.get(key);
        this.doRemove((String)key);
        return previousValue;
    }

    protected abstract void doRemove(String var1);

    @Override
    public V put(String key, V value) {
        V previousValue = null;
        try {
            previousValue = this.doGet(key);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.doPut(key, value);
        return previousValue;
    }

    protected abstract void doPut(String var1, V var2);

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.size());
        for (String key : this.keySet()) {
            values.add(this.get(key));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashSet<Map.Entry<String, V>> entrySet = new HashSet<Map.Entry<String, V>>();
        for (String key : this.keySet()) {
            entrySet.add((Map.Entry<String, V>)new DefaultMapEntry((Object)key, this.get(key)));
        }
        return entrySet;
    }

    @Override
    public boolean containsValue(Object value) {
        for (String key : this.keySet()) {
            if (!value.equals(this.get(key))) continue;
            return true;
        }
        return false;
    }
}

