/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.dwb.writer;

import java.nio.charset.Charset;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.capabilities.AttributesCapable;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.FunctionType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NullType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.RangeType$;
import org.mule.weave.v2.model.types.RegexType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.module.dwb.DefaultWeaveBinaryDataFormat$;
import org.mule.weave.v2.module.dwb.DwTokenHelper$;
import org.mule.weave.v2.module.dwb.DwTokenType$;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException;
import org.mule.weave.v2.module.dwb.reader.exceptions.DWBRuntimeExecutionException$;
import org.mule.weave.v2.module.dwb.writer.WeaveBinaryWriter;
import org.mule.weave.v2.module.dwb.writer.WeaveBinaryWriterSettings;
import org.mule.weave.v2.module.writer.TargetProvider;
import scala.Option;
import scala.runtime.BoxesRunTime;

public final class WeaveBinaryWriter$ {
    public static WeaveBinaryWriter$ MODULE$;
    private final int VERSION;
    private final int HEADER_BYTES;
    private final int MAGIC_WORD;
    private final Charset charset;

    static {
        new WeaveBinaryWriter$();
    }

    public WeaveBinaryWriterSettings $lessinit$greater$default$2() {
        return (WeaveBinaryWriterSettings)DefaultWeaveBinaryDataFormat$.MODULE$.createWriterSettings();
    }

    public int VERSION() {
        return this.VERSION;
    }

    public int HEADER_BYTES() {
        return this.HEADER_BYTES;
    }

    public int MAGIC_WORD() {
        return this.MAGIC_WORD;
    }

    private Charset charset() {
        return this.charset;
    }

    public WeaveBinaryWriter apply(TargetProvider targetProvider, WeaveBinaryWriterSettings settings, EvaluationContext ctx) {
        return new WeaveBinaryWriter(targetProvider.asOutputStream(ctx), settings, ctx);
    }

    public byte booleanToInt(boolean bl) {
        return bl ? (byte)1 : 0;
    }

    public int getStringTokenType(int length) {
        return length < 256 ? DwTokenType$.MODULE$.String8() : DwTokenType$.MODULE$.String32();
    }

    public int getKeyTokenType(boolean hasNs, boolean hasAttrs) {
        return hasNs && hasAttrs ? DwTokenType$.MODULE$.KeyWithNSAttr() : (hasNs ? DwTokenType$.MODULE$.KeyWithNS() : (hasAttrs ? DwTokenType$.MODULE$.KeyWithAttr() : DwTokenType$.MODULE$.Key()));
    }

    public int valueToTokenType(Value<?> v, EvaluationContext ctx) {
        int n;
        Option schemaMaybe = v.schema(ctx);
        boolean hasSchema = schemaMaybe.isDefined();
        Value<?> value = v;
        if (KeyType$.MODULE$.accepts(value, ctx)) {
            Value<?> key = v;
            QualifiedName ek = (QualifiedName)key.evaluate(ctx);
            n = this.getKeyTokenType(ek.namespace().isDefined(), ((AttributesCapable)key).attributes(ctx).isDefined());
        } else if (StringType$.MODULE$.accepts(value, ctx)) {
            String str = v.evaluate(ctx).toString();
            byte[] strBytes = str.getBytes(this.charset());
            int length = strBytes.length;
            n = this.getStringTokenType(length);
        } else if (BooleanType$.MODULE$.accepts(value, ctx)) {
            boolean bool = BoxesRunTime.unboxToBoolean((Object)v.evaluate(ctx));
            n = bool ? DwTokenType$.MODULE$.True() : DwTokenType$.MODULE$.False();
        } else if (NumberType$.MODULE$.accepts(value, ctx)) {
            Number number = (Number)v.evaluate(ctx);
            n = number.isWhole() ? (number.withinInt() ? DwTokenType$.MODULE$.Int() : (number.withinLong() ? DwTokenType$.MODULE$.Long() : DwTokenType$.MODULE$.BigInt())) : (number.withinDouble() ? DwTokenType$.MODULE$.Double() : DwTokenType$.MODULE$.BigDecimal());
        } else if (NullType$.MODULE$.accepts(value, ctx)) {
            n = DwTokenType$.MODULE$.Null();
        } else if (RangeType$.MODULE$.accepts(value, ctx)) {
            n = DwTokenType$.MODULE$.Range();
        } else if (ArrayType$.MODULE$.accepts(value, ctx)) {
            n = DwTokenType$.MODULE$.ArrayStart();
        } else if (ObjectType$.MODULE$.accepts(value, ctx)) {
            n = DwTokenType$.MODULE$.ObjectStart();
        } else {
            if (FunctionType$.MODULE$.accepts(value, ctx)) {
                throw new DWBRuntimeExecutionException("Writing function values is not supported.", DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
            }
            if (RegexType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.Regex();
            } else if (DateTimeType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.DateTime();
            } else if (LocalDateTimeType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.LocalDateTime();
            } else if (LocalDateType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.LocalDate();
            } else if (TimeType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.Time();
            } else if (LocalTimeType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.LocalTime();
            } else if (TimeZoneType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.TimeZone();
            } else if (BinaryType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.Binary();
            } else if (PeriodType$.MODULE$.accepts(value, ctx)) {
                n = DwTokenType$.MODULE$.Period();
            } else {
                throw new DWBRuntimeExecutionException(new StringBuilder(24).append("Unexpected value type '").append(value.toString()).append("'").toString(), DWBRuntimeExecutionException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        int tokenType = n;
        int hasSchemaProp = this.booleanToInt(hasSchema) << DwTokenHelper$.MODULE$.SCHEMA_FLAG_RIGHT_BITS_BYTE();
        return hasSchemaProp | tokenType;
    }

    private WeaveBinaryWriter$() {
        MODULE$ = this;
        this.VERSION = 1;
        this.HEADER_BYTES = 6;
        this.MAGIC_WORD = 2134985798;
        this.charset = Charset.forName("UTF-8");
    }
}

